/**
******************************************************************************
* @file    makeFilter.cpp
* @author  Hemant Kapoor
* @date    18-July-2019
* @brief   Make filter class
******************************************************************************
**/

#pragma once
#define _USE_MATH_DEFINES
#include "math.h"
#include "mbed.h"

namespace MakeFilterName
{
    const double FPKEXP709 = 0x2be5dc9b7fdd422d;
    struct complexStruct
    {
        double Real;
        double Img;
        //complexStruct(double r,double  i):Real(r),Img(i){}
        complexStruct operator +(complexStruct number2)const { complexStruct x = {(Real + number2.Real),(Img + number2.Img)}; return x; }  
        complexStruct operator -(complexStruct number2)const { complexStruct x = {(Real - number2.Real),(Img - number2.Img)}; return x; }  
        complexStruct operator *(complexStruct number2)const { complexStruct x = {(Real * number2.Real - Img * number2.Img),(Real * number2.Img + Img * number2.Real)}; return x; } 
        complexStruct operator /(complexStruct number2)const { 
                                                                                                                        complexStruct x = {
                                                                                                                                                                ((Real*number2.Real + Img*number2.Img)/(number2.Real*number2.Real + number2.Img*number2.Img)),
                                                                                                                                                                ((Img*number2.Real - Real*number2.Img)/(number2.Real*number2.Real + number2.Img*number2.Img))}; 
                                                                                                                                                                return x;}
        
                                                                                                                                                                
                                                                                                                                                                
     complexStruct Exp() const {
   double sinval, cosval, expval, exparg;
   complexStruct w;
   
   sinval = sin(Img);                /* sine of imaginary part of argument */
   cosval = cos(Img);                /* cosine of imaginary part of argument */
   
   if (Real <= 709.0) {               /* exp(Real(z)) is finite */
      expval = exp(Real);             /* evaluate exponential */
      w.Real = cosval*expval;           /* real result = cos(Imag(z))*exp(Real(z)) */
      w.Img = sinval*expval;           /* imag result = sin(Imag(z))*exp(Real(z)) */
   }
   
   else if (fpclassify(Real) < FP_ZERO) {      /* Real(z) = +INF or a NaN */
      w.Real = cosval*Real;             /* deserved invalid may occur */
      w.Img = sinval*Real;             /* deserved invalid may occur */
   }
   
   else if (Real > 1460.0) {          /* probable overflow case */
      w.Real = scalbn(cosval,2100);
      w.Img  = scalbn(sinval,2100);
   }
   else {           /* exp(Real(z)) overflows but product with sin or cos may not */
      w.Real = cosval*FPKEXP709;   /* initialize real result */
      w.Img = sinval*FPKEXP709;   /* initialize imag result */
      exparg = Real - 709.0;          /* initialize reduced exponent argument */
      while (exparg > 709.0) {        /* exponential reduction loop */
         w.Real *= FPKEXP709;
         w.Img *= FPKEXP709;
         exparg -= 709.0;
      }
      expval = exp(exparg);           /* final exponential value */
      w.Real *= expval;                 /* final multiplication steps */
      w.Img *= expval;
   }
   return w;                          /* done */            
        }           //{complexStruct x = {exp(Real),exp(Img)}; return x; }
        


  complexStruct Negate() const {complexStruct x = {-Real,-Img}; return x; }
    };
    
    const int MAXORDER = 10;
    const int MAXPOLES = 2 * MAXORDER;

    const complexStruct m_cmone = {-1, 0.0};
    const complexStruct m_czero = {0.0, 0.0};
    const complexStruct m_cone = {1.0, 0.0};
    const complexStruct m_ctwo = {2.0, 0.0};
    const complexStruct m_chalf = {0.5, 0.0};
    
};


class MakeFilter
{
public:     
    MakeFilter(int ord, float freq, float sampleFreq);
//    ~MakeFilter();
    double getGain() const{ return m_dcGain.Real; }
    double* getXCoeff() { return m_xcoeffs; }
    double* getYCoeff() { return m_ycoeffs; }

    
private:
    int m_order, m_numPoles;
    double m_rawAlpha1, m_rawAlpha2;
    MakeFilterName::complexStruct m_dcGain, m_fcGain, m_hfGain;
    uint32_t m_opts;   /* option flag bits */

    double m_warpedAlpha1, m_warpedAlpha2, m_chebrip;
    uint32_t m_poleMask;
    bool m_optsok;  


    MakeFilterName::complexStruct m_spoles[MakeFilterName::MAXPOLES];
    MakeFilterName::complexStruct m_zPoles[MakeFilterName::MAXPOLES];
    MakeFilterName::complexStruct m_zZeros[MakeFilterName::MAXPOLES];

    double m_xcoeffs[MakeFilterName::MAXPOLES + 1];
    double m_ycoeffs[MakeFilterName::MAXPOLES + 1];
    
    void compute_s();
    void normalize();
    void compute_z();
    void expandpoly();
    void choosepole(MakeFilterName::complexStruct z);
    void expand(MakeFilterName::complexStruct pz[], MakeFilterName::complexStruct coeffs[]);
    void multin(MakeFilterName::complexStruct w, MakeFilterName::complexStruct coeffs[]);
    MakeFilterName::complexStruct evaluate(MakeFilterName::complexStruct topco[], MakeFilterName::complexStruct botco[], int np, MakeFilterName::complexStruct z) ;
    MakeFilterName::complexStruct eval(MakeFilterName::complexStruct coeffs[], int np, MakeFilterName::complexStruct z);
};

