#pragma once
/*
* Butterworth low pass filter with aribitaty parameters.
* Could be made faster by using arm DSP libraries for filters with an even order.
* Libraries impliment the same basic structure but in a more efficent way.
*
*/

class LowPassFilter
{
public:
    LowPassFilter();
    LowPassFilter(int order, float frequency, float sampleRate);
    ~LowPassFilter();
    
    float addPoint(float point);
    float lastValue() { return *m_lastOut;  };
    bool makeFilter(int order, float frequency, float sampleRate);
    bool isEnabled()
    {
        return m_enable;
    };
private:

    void freeBuffers();
    bool createBuffers(int order);

    float *m_inValues;
    float *m_outValues;
    float *m_inScale;
    float *m_outScale;
    int m_order;
    bool m_enable;
    float m_lastIn;
    float *m_lastOut;
};
