#ifndef __FIZReader_H__
#define __FIZReader_H__
#include "BufferedSerial.h"
#include <vector>

class FIZReader {

public:
  FIZReader(const PinName Tx, const PinName Rx);
  virtual void requestCurrent() = 0;

    /// true if the values have been updated since the last update.
    // focus and zoom are in mm, iris is in 100ths of a stop
  bool getMostRecent(uint32_t *focus, uint16_t *iris, uint16_t *zoom);

protected:
  int hexValue(char ascii);
  unsigned int getAbsoluteValue(unsigned int encoder_pos, vector<unsigned int> &encoder_range, vector<unsigned int> &absolute_range);
  uint32_t getAbsoluteFocus(uint32_t encoder_pos);
  uint16_t getAbsoluteIris(uint16_t encoder_pos);
  uint16_t getAbsoluteZoom(uint16_t encoder_pos);
  RawSerial _port;
   
    uint32_t _focus; // in mm
    uint16_t _iris; // in 100ths of F stop
    uint16_t _zoom; // in mm
    bool newData;
        
};

#endif
