#ifndef __FIZDigiActive_H__
#define __FIZDigiActive_H__
#include "FIZReader.h"

//FIZ protocol used for digipower box.
// this is listen only.

class FIZDigiPowerActive : public FIZReader
{

public:
    FIZDigiPowerActive(const PinName Tx, const PinName Rx);
    virtual void requestCurrent();

private:
    static const int InBufferSize = 32;

    void OnRx(void);
    void parsePacket();
    void read_lens_parameters();
    float get_16bit_float(uint16_t val);

    int missedPackets;
    uint8_t inputBuffer[InBufferSize];
    int inputPtr;
    uint16_t min_zoom;
    uint16_t max_zoom;
    bool initialising;
};


#endif
