#include "frameclock.h"

frameclock::frameclock()
{
    _hour = 0;
    _minute = 0;
    _second = 0;
    _frame = 0;
    _rate = 24;
    _drop = false;
}

frameclock::frameclock(int hour, int minute, int second, int frame, int rate, bool drop)
{
    _hour = hour;
    _minute = minute;
    _second = second;
    _frame = frame;
    _rate = rate;
    _drop = drop;
}

void frameclock::setMode(int rate, bool drop)
{
    _rate = rate;
    _drop = drop;
}
void frameclock::setTime(int hour, int minute, int second, int frame)
{
    _hour = hour;
    _minute = minute;
    _second = second;
    _frame = frame;
}


void frameclock::nextFrame()
{
    _frame++;
    if (_frame == _rate) {
        _second++;
        if (_second==60) {
            _second = 0;
            _minute++;
            if (_minute == 60) {
                _minute = 0;
                _hour++;
                if (_hour==24)
                    _hour = 0;
            }

            if (_drop && (_minute % 10 != 0))
                _frame = 2;
            else
                _frame = 0;
        } else { // else not end of minute
            _frame = 0;
        }
    }
}

