#ifndef __frameRates_h__
#define __frameRates_h__

namespace frameRateInfo {

  const float FrameRates[] = {0,     23.976, 24, 25,    29.97, 30,
                      47.95, 48,     50, 59.94, 60,    10000000};

/// us                      
const double FramePeriods[] = {1000000,         1000000 / 23.976, 1000000 / 24,
                         1000000 / 25,    1000000 / 29.97,  1000000 / 30,
                         1000000 / 47.95, 1000000 / 48,     1000000 / 50,
                         1000000 / 59.94, 1000000 / 60,     10};

const int numberOfRates = 11;
}

class frameRates {

public:

frameRates();

    void setRate(int index);
    void setDrop(bool drop) {_currentDrop = drop;};
    bool isSyncable();
    bool isValid() {return _currentRate!=0;};

const char *frameRateString();
// gets time since the start of the second in us.
// in some frame drop modes this could be negative.
static long getOffsetFromSecondStart(int minutes, int seconds, int frame,
                              int rateIndex, bool frameDrop);

// gets time since the start of the second in us.
// in some frame drop modes this could be negative.
long getOffsetFromSecondStart(int minutes, int seconds, int frame);


    float currentRate() {return _currentRate;};
    double currentPeriodUS() {return _currentPeriod;};
    int currentIndex() {return _currentIndex;};
    bool currentDrop() {return _currentDrop;};

static int getClosestRate(long int framePeriodUS);

private:
float _currentRate;
double _currentPeriod;
int _currentIndex;
bool _currentDrop;
};


#endif
