#include "LTCApp.h"



const float FrameRates[] = {0,     23.976, 24, 25,    29.97, 30,
                            47.95, 48,     50, 59.94, 60,    10000000
                           };
//const double FramePeriods[] = {1000000,         1000000 / 23.976, 1000000 / 24,
//                               1000000 / 25,    1000000 / 29.97,  1000000 / 30,
//                               1000000 / 47.95, 1000000 / 48,     1000000 / 50,
//                               1000000 / 59.94, 1000000 / 60,     10
//                              };
//const int numberOfRates = 11;


frameRates::frameRates() {
    setRate(1);
}

void frameRates::setRate(int index) {
    _currentRate = frameRateInfo::FrameRates[index];
_currentPeriod = frameRateInfo::FramePeriods[index];
_currentIndex = index;
TimeSinceLastFrameWrap =  frameRateInfo::FramePeriods[index];
}

bool frameRates::isSyncable() {
  if (_currentIndex < 2) // 0 or 1
    return false;
  if (((_currentIndex == 4) || (_currentIndex == 9)) && !_currentDrop)
    return false;
  return true;
}


const char *frameRates::frameRateString() {
  switch (_currentIndex) {
  case 0:
  default:
    return "Unknown";
  case 1:
    return "23.976";
  case 2:
    return "24";
  case 3:
    return "25";
  case 4:
    return _currentDrop ? "29.97 Drop" : "29.97";
  case 5:
    return "30";
  case 6:
    return "47.95";
  case 7:
    return "48";
  case 8:
    return "50";
  case 9:
    return _currentDrop ? "59.94 Drop" : "59.94";
  case 10:
    return "60";
  }
}


long frameRates::getOffsetFromSecondStart(int minutes, int seconds, int frame,
                              int rateIndex, bool frameDrop){
  if (!frameDrop) {
    return frameRateInfo::FramePeriods[rateIndex] *
           frame; // for non frame drops all second starts are perfect
                  // not true for non-integer rates but for non-drop versions we
                  // don't try to sync to those.
  } else {
    int MinutesSinceLastSync = minutes % 10;
    const int framesPerMinute = 30 * 59 + 28;

//    double indicatedTimeSinceLastSync =
//        (MinutesSinceLastSync * framesPerMinute + seconds * 30 + frame) *
//        frameRateInfo::FramePeriods[rateIndex];
    double framesMismatch =
        (MinutesSinceLastSync * framesPerMinute + seconds * 30) -
        (frameRateInfo::FrameRates[rateIndex] * (MinutesSinceLastSync * 60 + seconds));
    double timeErrorAtSecondStart = framesMismatch * frameRateInfo::FramePeriods[rateIndex];
    double timeThisSecond = frame * frameRateInfo::FramePeriods[rateIndex];
    return (long)(timeThisSecond + timeErrorAtSecondStart + 0.5);
  }
}

long frameRates::getOffsetFromSecondStart(int minutes, int seconds, int frame){
  if (!_currentDrop) {
    return _currentPeriod * frame; // for non frame drops all second starts are perfect
                  // not true for non-integer rates but for non-drop versions we
                  // don't try to sync to those.
  } else {
    int MinutesSinceLastSync = minutes % 10;
    const int framesPerMinute = 30 * 59 + 28;

//    double indicatedTimeSinceLastSync =
//        (MinutesSinceLastSync * framesPerMinute + seconds * 30 + frame) * _currentPeriod;
    double framesMismatch =
        (MinutesSinceLastSync * framesPerMinute + seconds * 30) - (_currentRate * (MinutesSinceLastSync * 60 + seconds));
    double timeErrorAtSecondStart = framesMismatch * _currentPeriod;
    double timeThisSecond = frame * _currentPeriod;
    return (long)(timeThisSecond + timeErrorAtSecondStart + 0.5);
  }
}

int frameRates::getClosestRate(long int framePeriodUS)
{
    int indexOver = 1;
    while (framePeriodUS <= frameRateInfo::FramePeriods[indexOver])
        indexOver++;
    float amountOver = framePeriodUS - frameRateInfo::FramePeriods[indexOver];
    float amountUnder = frameRateInfo::FramePeriods[indexOver - 1] - framePeriodUS;
    if (amountOver > amountUnder)
        indexOver--;
    return (int)(FrameRates[indexOver]+0.5);
}

