#ifndef __VIPSSERIALPROTOCOL_H__
#define __VIPSSERIALPROTOCOL_H__

#include "mbed.h"
#include "position.h"
#include "BufferedSerial.h"
#include "LTCApp.h"
#include "LowPassFilter.h"

#define MaxBuffSize 272 //The Get Unit Info LPC command (G N) returns 266 bytes



extern const char* VIPSStatusMessages[];
struct UserSettings_s;

class VIPSSerial
{

public:

    VIPSSerial(const PinName Tx, const PinName Rx);
    void run(void);
    bool setFilters(struct UserSettings_s *settings);

    // send all position outputs rather than just when requested.
    void sendAllUpdated(bool enable);

    // send a position output for the requested time. Times are based on the global TimeSinceLastFrame timer.
    position* sendPositionForTime(uint32_t timeValue);
    position* getWaitingPostion()
    {
        position *ptr = outputPtr;
        outputPtr=NULL;
        return ptr;
    }

    static void getCRC(void *data, int len, void *checksum);

//  void setOutMask(uint32_t outputMask) {_outputMask = outputMask;};

    bool EnableSmoothing(bool enabled)
    {
        hyperSmoothEnabled = enabled;
        return hyperSmoothEnabled;
    };
    bool SmoothingEnabled(void)
    {
        return hyperSmoothEnabled;
    };
    bool ForceSmoothing(bool enabled)
    {
        forcedHyperSmooth = enabled;
        hyperSmoothEnabled = enabled;
        return hyperSmoothEnabled;
    };
    bool ForceSmoothingEnabled(bool enabled)
    {
        return forcedHyperSmooth;
    };
    int GetSmoothLevel(void)
    {
        return SmoothBy;
    };
    bool SetSmoothLevel (const int newSmooth)
    {
        if (newSmooth == SmoothBy) return false;
        SmoothBy = newSmooth;
        SmoothRunning = false;
        return true;
    };
    void EnableBypass(bool enable)
    {
        BypassMode = enable;
    };
    void bypassTx(char byte);
    void sendQueued(void);
    bool EnableDirectTX(bool enabled)
    {
        directTx = enabled;
        return directTx;
    };
    void sendDirectTX(unsigned char* data, int dataLen);
    int getWaitingBuffer(unsigned char **TXBuffer, int *bytesToSend);
    void sendQuiet(void);

private:

    struct posAndTime_s {
        uint32_t time;
        position pos;
    };

    void smoothOutputPacket(position *posPtr);
    void onSerialRx(void);
    void processRxMessage();
    bool checkCRC(unsigned char* data);
    void sendResponse(unsigned char function, unsigned char* data, int dataLen);
    void queueResponse(unsigned char function, unsigned char* data, int dataLen);
    void sendAck(unsigned char function);
    void sendNack(unsigned char function);
    void sendVBOXTime();
    void parsePostionInput_legacy();
    void parsePostionInput_mocap();
    void onTxTimeout();
    bool checkNewPacketRC(unsigned char* data);
    RawSerial _port;
    unsigned char messageInBuffer[128];
    unsigned char messageOutBuffer[16];
    unsigned char TXBuffer1[MaxBuffSize];
    unsigned char TXBuffer2[MaxBuffSize];
    unsigned char *txBuf;
    int waitingBytes;
#define posHistoryLen 3
    struct posAndTime_s lastPositions[posHistoryLen];
    int nextPosition;
    struct posAndTime_s lastPos; // the most recent position received
    struct posAndTime_s prevPos; // the most last but one position received

    position outputPosition;
    position *outputPtr;

    int messagePrt;
    int messageLength;
    int statusMessage;
    bool enableAllUpdates;
    bool newFormatMsg;
    bool hyperSmoothEnabled;
    bool forcedHyperSmooth;
    bool directTx;
    uint32_t pointCount;
    uint32_t _outputMask;

    int queueLen;
    int SmoothBy;
    // total as a float we would start to see rounding errors at valuses of ~20m
    double XSmoothTotal;
    double YSmoothTotal;
    double ZSmoothTotal;
    bool SmoothRunning;
    bool BypassMode;
    LowPassFilter yFilter;
    LowPassFilter xFilter;
    LowPassFilter zFilter;
    LowPassFilter rollFilter;
    LowPassFilter pitchFilter;
    LowPassFilter yawFilter;
    
    Timeout TxTimeout;
    bool TransmitFinished;
    //VIPSSerial* self;
};

#endif
