#ifndef __LTCApp_h__
#define __LTCApp_h__

#include "mbed.h"
#include "LTCDecode.h"
#include "VIPSSerialProtocol.h"
#include "frameRates.h"
#include "BufferedSerial.h"
#include "FIZ_DISNEY.h"
#include "FIZ_digiPower.h"
#include "FIZDigiPowerActive.h"
#include "FIZCanon.h"
#include "FIZ_ArriCmotion.h"
#include "frameclock.h"
#include "FreeD.h"
#include <stdint.h>
#include <vector>

extern volatile uint32_t VBOXTicks;
extern volatile bool ppsActive;

extern BufferedSerial pc;

extern frameRates detectedRate;

extern Timer TimeSinceLastFrame;
extern uint32_t TimeSinceLastFrameWrap;
extern DigitalOut led1;

extern void vipsBypassRx(char byte);

typedef struct UserSettings_s {
    int FIZmode;
    int SerialOutMode;
    int FreeDPort;
    int DataOutPort;
    int VipsUDPPort;
    int SettingsPort;
    char IPAddress[32];
    char Gateway[32];
    char Subnet[32];
    int FilterOrder;
    float FilterFreq;
    float FilterRate;
    bool FilterXY;
    bool FilterZ;
    bool FilterRoll;
    bool FilterPitch;
    bool FilterYaw;
    bool AutoHyperSmooth;
    bool FlexibleVIPSOut;
    float SerialTxDelayMS;
    float UDPTxDelayMS;
    float SerialTxDelayFrame;
    float UDPTxDelayFrame;
    float InterpolationOffset_uS;
    float InterpolationOffsetFrame;
    bool InvertRoll;
    bool InvertPitch;
    bool InvertYaw;
    int OffsetRoll;
    int OffsetPitch;
    int OffsetYaw;
    int bypassBaud;
    bool ForcePPF;
    bool HalfRate;
    float focus_scale;
    float focus_offset;
    float iris_scale;
    float iris_offset;
    float zoom_scale;
    float zoom_offset;
    bool low_zoom_precision;
    bool absolute_focus;
    bool absolute_iris;
    bool absolute_zoom;
    vector<unsigned int> focus_encoder_map;
    vector<unsigned int> focus_absolute_map;
    vector<unsigned int> iris_encoder_map;
    vector<unsigned int> iris_absolute_map;
    vector<unsigned int> zoom_encoder_map;
    vector<unsigned int> zoom_absolute_map;
} UserSettings_t;

extern UserSettings_t UserSettings;

// extern int pos_upper;
// extern int pos_lower;
// extern int pos_value;

#endif
