#ifndef __FreeD_h__
#define __FreeD_h__

#include "mbed.h"
#include <cstdint>

struct D1MsgFormat_s {
    uint8_t header; //0xD1, annoying it cant be set as default value here!
    uint8_t id; //camera ID, use 255 minus Rover ID
    uint8_t yaw[3];
    uint8_t pitch[3];
    uint8_t roll[3];
    uint8_t x[3];
    uint8_t y[3];
    uint8_t z[3];
    uint8_t zoom[3];
    uint8_t focus[3];
    uint16_t spare;
    uint8_t checksum;
} __attribute__((packed)) ;


inline void set24bitValue(uint8_t *target, int32_t value)
{
    *target = (uint8_t) ((value>>16) & 0xff);
    *(target+1) = (uint8_t) ((value>>8) & 0xff);
    *(target+2) = (uint8_t) (value & 0xff);
}

inline int GetFdCRC(void *data) {
    uint8_t *dataPtr = (uint8_t *)data;
    //uint8_t *crcPtr = (uint8_t *)checksum;
    int len = sizeof(D1MsgFormat_s) -1;
    uint8_t sum =0;
    int byteCount = 0;

    while ((len--) > 0) {sum += dataPtr[byteCount++];}
        
    //crcPtr[0] = 0x40 - sum;
    return 0x40 - sum;
}


#endif
