#ifndef __FIZCanon_H__
#define __FIZCanon_H__
#include "FIZReader.h"

//FIZ protocol used for Canon Lens.

class FIZCanon : public FIZReader
{

public:
    FIZCanon(const PinName Tx, const PinName Rx);
    virtual void requestCurrent();

private:
    static const int InBufferSize = 32;

    void OnRx(void);
    void parsePacket();

    int missedPackets;
    uint8_t inputBuffer[InBufferSize];
    int inputPtr;
};

#define CANON_ZOOM  0xC1
#define CANON_FOCUS 0xC3
#define CANON_IRIS  0xC5
#define CANON_START 0x94


#endif
