#include "mbed.h"
#include "C12832.h"
 // LR 10/02/18
 //
 // bus CAN generateur de trames
 //
 // Emission d'une trame parmi 4 selection à l'aide du pot1
 // eviter les positions intermédaires du pot1 !
 //  !! emission sur CAN2 p30Rx p29Tx
 // Attention si pas d'ACK faire reset après chaque changement
 // J'ai constaté des comportements bizarre dans cette situation
 // Des infos sur la liaison série
 // La trame est envoyée aussi sur LCD
 // 
 // testé à l'analyseur logique = OK !!
 //
 //
 
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10,1000000);// on definit pin et debit
CAN can2(p30, p29, 1000000);
Serial pc(USBTX, USBRX);
AnalogIn   pot_1(p19); // potard pour selection
C12832 lcd(p5, p7, p6, p8, p11); // lcd


void send(int id, char octet_emis[], char RouD, char longueur )
{
    int emis_ok = 0 ;
    CANMessage msg;
    if (RouD == 'D')
    { emis_ok = can2.write(CANMessage(id, octet_emis, longueur, CANData, CANStandard )) ;
      pc.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
    }// c'ets la valeur retournée par la fonction write
   else
    { emis_ok = can2.write(CANMessage(id, octet_emis, longueur,  CANRemote, CANStandard ));
        pc.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
         }
    lcd.locate(0,10);
    lcd.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
    if(emis_ok) {
        // ici octet emis n'a pas de sens car trame remote !
     pc.printf("j'emets bien !!! \n");
    } 
    led1 = !led1;
}



 
int main() {
    int choix = 0 ;
    int i = 0 ;
    
char octet_send[9]  = "DDDDDDDD"; // valeurs par defaut D=44
int identif = 0x123 ; // par défaut
char RemoteData = 'D' ;  
char length = 2 ;


    printf("main()\n");
     lcd.cls();
   
   
    while(1) {
    choix= 5*pot_1.read();
    lcd.locate(0,0);
    lcd. printf("Trame %d \n", choix);
    switch (choix)
    { // debut sw
    case (0): // Trame qui passe le noeud 15 en Operationnal state
    {   identif =  0x00 ;
        octet_send[0] = 0x01 ;
        octet_send[1] = 0x15 ;
        RemoteData = 'D';
        length = 2 ;
        break ;
    }     // fin case 0
     case (1): // Trame qui passe le noeud 20 en Operationnal state
    {   identif =  0x00 ;
         octet_send[0] = 0x01 ;
        octet_send[1] = 0x20 ;
        RemoteData = 'D';
       length = 2 ;
        break ;
    }     // fin case 1
     case (2): // trame qui ping le noeud 15
    {   identif =  0x715 ;
        for(i=0;i<9;i++)
        { octet_send[i]='D';} // 44 en hexa par defaut
        RemoteData = 'R';
        length = 0 ;
        break ;
    }     // fin case 2
    case (3): // trame qui ping le noeud 20
    {   identif =  0x720 ;
         for(i=0;i<9;i++)
        { octet_send[i]='D';} // 44 en hexa par defaut
        RemoteData = 'R';
        length = 0 ;
        break ;
    }     // fin case 3
    
   default : // 4 ou 5
    {   identif =  0x123 ;
         for(i=0;i<9;i++)
        { octet_send[i]='D';} // 44 en hexa par defaut
        RemoteData = 'D';
        length = 8 ;
        break ;
    }     // fin default
    
    } // fin switch
    
    send(identif, octet_send, RemoteData, length );
         wait(1);
    }// fin while(1)
         
} // fin main
         
        /*
        
        printf("loop()\n");
        if(can2.read(msg)) {
            printf("Message received: %d\n", msg.data[0]);
            led2 = !led2;
        } 
        wait(0.2);
    }
} */

