#include "mbed.h"
#include "can_parameters.h"

AnalogIn joystick_ctr(p15);   // Pin 2 (fil vert) Center Tap Reference
AnalogIn joystick_x(p16);     // Pin 4 (fil jaune)
AnalogIn joystick_y(p17);     // Pin 5 (fil bleu)

DigitalOut MOTOR1_OP(LED1);     // etat opérationnel ou non
DigitalOut MOTOR2_OP(LED2);
DigitalOut DEB_MOD_DEG(LED3);   // Si mod degradé ou normal
DigitalOut DEB_MOD_NOR(LED4);
DigitalOut MOD_DEG(p26);
DigitalOut MOD_NOR(p25);

int x = 0;      // Poisition joystick x, y
int y = 0;
int ctr_x = 0;  // Centre de reference x,y
int ctr_y = 0;

DigitalIn myPOM(p7); // Detection du pull up POM
bool etat_POM = false;      // Etat de la machine N ou M
DigitalIn Switch_H(p5);  // Detection pull up switch Horizontal
DigitalIn Switch_V(p6);  // Detection pull up switch Vertical

CAN can_mbed(p30, p29, 1000000);
char command[8]; //word to send command
CANMessage msg;


// FONCTIONS
void send(int id, char octet_emis[], char RouD, char longueur ) // Fonction qui envoie les données sur le bus can
{
    
    if (RouD == 'D')
    { 
        CANMessage(id, octet_emis, longueur, CANData, CANStandard );
    }
    else
    { 
        CANMessage(id, octet_emis, longueur,  CANRemote, CANStandard );    
    }
}


/*void initialisation()   // Fonction qui initialise les moteurs
{
    int ping = 0;
    // Initialisation moteur droit
    command[0] = DRIVER_R1; // Moteur droit
    command[1] = DRIVER_R2;
        
    while(ping == 0)    
    {
        MOTOR1_OP = 1;  // Animation led
        wait(0.2);
        MOTOR1_OP = 0;
        wait(0.2);
        send(INITOP, command, 'D', 2); //send word to put pluto driver in operational mode
        if(can_mbed.read(msg))  // Si réponse alors on sort de la boucle
        {
            ping = 1;
        }
    }*/
    /*// Initialisation moteur gauche
    ping = 0;
    command[0] = DRIVER_L1; // Moteur gauche
    command[1] = DRIVER_L2;
        
    while(ping == 0)    
    {
        MOTOR2_OP = 1;  // Animation led
        MOTOR2_OP = 0;
        send(INITOP, command, 'D', 2); //send word to put pluto driver in operational mode
        if(can_mbed.read(msg))  // Si réponse alors on sort de la boucle
        {
            ping = 1;
        }
    }
    MOTOR1_OP = 1;
    MOTOR1_OP = 1;
}*/

// MAIN
int main()
{   
    // SETUP
    myPOM.mode(PullUp);     // Définition des pull up
    Switch_H.mode(PullUp);  
    Switch_V.mode(PullUp);
    // FIN SETUP

    

    //initialisation();
   int ping = 0;
    // Initialisation moteur droit
    command[0] = DRIVER_R1; // Moteur droit
    command[1] = DRIVER_R2;
        
    while(ping == 0)    
    {
        MOTOR1_OP = 1;  // Animation led
        wait(0.2);
        MOTOR1_OP = 0;
        wait(0.2);
        send(INITOP, command, 'D', 2); //send word to put pluto driver in operational mode
        if(can_mbed.read(msg))  // Si réponse alors on sort de la boucle
        {
            ping = 1;
        }
    }
    
    while(1)
    {
        
        // LECTURE Joystick + stockage valeurs dans x, y
        if(Switch_H){x = int(-((joystick_x.read()*100)-50));}else{x=0;}
        if(Switch_V){y = int((joystick_y.read()*100)-50);}else{y=0;}
        ctr_x = int(-((joystick_ctr.read()*100)-50));
        ctr_y = int((joystick_ctr.read()*100)-50);
        
        printf("\nX : %d ",x);    // Lecture et affichage de la valeur lu en entré pour x et y
        printf(" Y : %d ",y);    // Valeur de type float entre 0 et 1
        printf(" CTR_x : %d , CTR_y : %d ", ctr_x, ctr_y);
        
        if((y<5)&&(y>-5))           // BOUGE PAS
        {
            command[0] = 0x00;
            command[1] = 0x00;
            command[2] = 0x00;
            command[3] = 0x00;
            send(RPDO1_R, command, 'D', 4); // Envoie l'ordre de pas bouger
        }
        else if((y>=5)&&(y<25))     // LENT SENS 1
        {
            command[0] = 0x00;
            command[1] = 0x00;
            command[2] = 0x00;
            command[3] = 0x00;
            send(RPDO1_R, command, 'D', 4); // Envoie l'ordre
        }
        else if(y>=25)              // MOYEN SENS 1
        {
            command[0] = 0x00;
            command[1] = 0x00;
            command[2] = 0x00;
            command[3] = 0x00;
            send(RPDO1_R, command, 'D', 4); // Envoie l'ordre
        }
        else if((y<=-5)&&(y>-25))   // LENT SENS 2
        {
            command[0] = 0x00;
            command[1] = 0x00;
            command[2] = 0x00;
            command[3] = 0x00;
            send(RPDO1_R, command, 'D', 4); // Envoie l'ordre
        }
        else if(y<=-25)             // MOYEN SENS 2
        {
            command[0] = 0x00;
            command[1] = 0x00;
            command[2] = 0x00;
            command[3] = 0x00;
            send(RPDO1_R, command, 'D', 4); // Envoie l'ordre
        }
    }
}
////////////////////////////////////////////////////////////////////////////////
/* BROCHAGE MBED :
PIN 15 --> Center Tap Reference 
PIN 16 --> Y (doc) --> X (Programme)
PIN 17 --> X (doc) --> Y (Programme) Pour bien définir selon le sens du joystick, câbles vers le haut

PIN 5 --> Switch Horizontal
PIN 6 --> Switch Vertical
PIN 7 --> BP Point Origine Machine

PIN 1 --> GND
PIN 40 --> 3.3V, Vout(out)
PIN 39 --> 5V, Vu (out)

PIN 30 --> Can Rd (connecté au PIN 4 Rx du controleur)
PIN 29 --> Can Td (connecté au PIN 1 Tx du controleur)

PIN 26 --> LED BORNIER Mode Normal
PIN 25 --> LED BORNIER Mode Dégradé
*/
////////////////////////////////////////////////////////////////////////////////