//Parameters of the robot
//includes CANopen codes and robot parameters


/*
Here is the list of the CANopen Codes to sent to the motor driver
There identifiers and word code
These parameters can be changed
*/


//Identifier Codes

/*
To set right value for:
RPDO1 => 0x200 + ID
RPDO2 => 0x300 + ID
RPDO3 => 0x400 + ID
RPDO4 => 0x500 + ID
TPDO1 => 0x180 + ID
TPDO2 => 0x280 + ID
TPDO3 => 0x380 + ID
TPDO4 => 0x480 + ID
*/


#define INITOP    0x00 
#define RPDO1_R   0x215
#define RPDO2_R   0x315
#define RPDO3_R   0x415
#define RPDO4_R   0x515
#define TPDO1_R   0x195
#define TPDO2_R   0x295
#define TPDO3_R   0x395
#define TPDO4_R   0x495
#define RPDO1_L   0x220
#define RPDO2_L   0x320
#define RPDO3_L   0x420
#define RPDO4_L   0x520
#define TPDO1_L   0x1A0
#define TPDO2_L   0x2A0
#define TPDO3_L   0x3A0
#define TPDO4_L   0x4A0





//Driver adresses for operational mode
//Example : DRIVER_R1 = 0x01  DRIVER_R2= 0x15  ---->  Code must be sent = DRIVER_R1 + DRIVER_R2 = 0x0115

#define DRIVER_R1 0x01
#define DRIVER_R2 0x15
#define DRIVER_L1 0x01
#define DRIVER_L2 0x20





//Robot setup

//Here is the configuration of the robot
//These value can be changed


//Length from motors to cursor in millimeters(mm) when the origin is taken

//Left motor to cursor
#define LENGTH_L1_PO 781

//Right motor to cursor
#define LENGTH_L2_PO 781

//Left motor to Right motor
#define LENGTH_MOTOR 1000

//Max velocity for normal mode
#define ALPHA   425000 

//Number of counters for 1 millimeters
#define REFERENCE 2545




/*Here is the default values


//Identifier Codes

#define INITOP    0x00 
#define RPDO1_R   0x215
#define RPDO2_R   0x315
#define RPDO3_R   0x415
#define RPDO4_R   0x515
#define TPDO1_R   0x195
#define TPDO2_R   0x295
#define TPDO3_R   0x395
#define TPDO4_R   0x495
#define RPDO1_L   0x220
#define RPDO2_L   0x320
#define RPDO3_L   0x420
#define RPDO4_L   0x520
#define TPDO1_L   0x1A0
#define TPDO2_L   0x2A0
#define TPDO3_L   0x3A0
#define TPDO4_L   0x4A0


//Driver adresses for operational mode
//Example : DRIVER_R1 = 0x01  DRIVER_R2= 0x15  ---->  Code must be sent = DRIVER_R1 + DRIVER_R2 = 0x0115

#define DRIVER11 0x01
#define DRIVER12 0x15
#define DRIVER21 0x01
#define DRIVER22 0x20



//Robot setup

//Here is the configuration of the robot
//These value can be changed


//Length from motors to cursor in millimeters(mm) when the origin is taken

//Left motor to cursor
#define LENGTH_L1_PO 781

//Right motor to cursor
#define LENGTH_L2_PO 781

//Left motor to Right motor
#define LENGTH_MOTOR 1000

//Max velocity for normal mode
#define ALPHA   425000 

//Number of counters for 1 millimeters
#define REFERENCE 2545




*/








