#include "mbed.h"
#include "can_parameters.h"
 /* 
  Projet BTS SN - Robot à câbles - Lycée Georges Cabanis
  Enzo Niro - Erwin Sazio
  Transmission par Bus CAN(protocol CANOpen)
  
 */
 
 




DigitalOut MOTOR1_OP(LED1);
DigitalOut MOTOR2_OP(LED2);
DigitalOut DEB_MOD_DEG(LED3);
DigitalOut DEB_MOD_NOR(LED4);
DigitalOut MOD_DEG(p26);
DigitalOut MOD_NOR(p25);
DigitalIn SWH(p5);
DigitalIn SWV(p6);
DigitalIn BPO(p7);

CAN can1(p9, p10,1000000);// on definit pin et debit
CAN can2(p30, p29, 1000000);
Serial pc(USBTX, USBRX);
//AnalogIn   pot_1(p19); // potard pour selection



void send(int id, char octet_emis[], char RouD, char longueur )
{
    int emis_ok = 0 ;
    
    if (RouD == 'D')
    { emis_ok = can2.write(CANMessage(id, octet_emis, longueur, CANData, CANStandard )) ;
      //pc.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
    }// c'ets la valeur retournée par la fonction write
   else
    { emis_ok = can2.write(CANMessage(id, octet_emis, longueur,  CANRemote, CANStandard ));
        //pc.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
         }
    //lcd.locate(0,10);
    //lcd.printf("id: %x, %c L = %d,  \nData : %x:%x:%x:%x ...   \n", id,RouD,longueur,octet_emis[0],octet_emis[1], octet_emis[2], octet_emis[3] );
    /*if(emis_ok) {
        // ici octet emis n'a pas de sens car trame remote !
     //pc.printf("send \r \n");
    } */
}



 
int main() {

    CANMessage msg;
    uint8_t ping = 0;
    char command[8]; //word to send command
        //define Pullup switch
        SWH.mode(PullUp);
        SWV.mode(PullUp);
        BPO.mode(PullUp);
        pc.printf("starting...\r\n");
            MOD_DEG = 1;
            wait(0.1);
            MOD_DEG = 0;
            wait(0.1);
            MOD_DEG = 1;
            wait(0.1);
            MOD_DEG = 0;
            wait(0.1);
            MOD_DEG = 1;
            wait(0.1);
            MOD_DEG = 0;
            wait(0.1);
        
        command[0] = DRIVER_R1;
        command[1] = DRIVER_R2;
        
        while(ping == 0){
            pc.printf("ping...\r\n");
            send(INITOP, command, 'D', 2); //send word to put pluto driver in operational mode
            MOD_NOR = 1;
            if(can2.read(msg)) {
                pc.printf("Done\r\n");
                ping = 1;
                }
            wait(0.1);
            MOD_NOR = 0;
            wait(0.9);
            
            }
        
        
        
    while(1){
        if(SWH == 0){
            wait(1.0);
            send(0x0195, command, 'R', 0); //send word to put pluto driver in operational mode
            wait(1);
            if(can2.read(msg)) {
            for(int i = 0; i < msg.len; i++){
            pc.printf("0x%x ",msg.data[i]);
            }//end of for
            pc.printf("\r \n");
            }//can.read(len)
            }//end of SWH == 0
            
        switch(BPO){
            case 0:

            switch(SWV){
                case 0:
                command[0] = 0x00;
                command[1] = 0x00;
                command[2] = 0xBF;
                command[3] = 0x00;
                send(RPDO1_R, command, 'D', 4); //send word to put pluto driver in operational mode
                break;
                
                case 1:
                command[0] = 0xFF;
                command[1] = 0xFF;
                command[2] = 0x40;
                command[3] = 0xFF;
                send(RPDO1_R, command, 'D', 4); //send word to put pluto driver in operational mode

                break;
                
            

                }
            
            break;
            
            case 1:
 
                command[0] = 0x00;
                command[1] = 0x00;
                command[2] = 0x00;
                command[3] = 0x00;
                send(RPDO1_R, command, 'D', 4); //send word to put pluto driver in operational mode
            break;
                 
                }
        
            
    }// fin while(1)
         
} // fin main
         
        