//Terminal CAN projet bts sn Enzo

#include "mbed.h"
 
#define BIG_ENDIAN          0
#define LITTLE_ENDIAN       1

#define MENU_DISPLAY            0
#define MENU_CHOOSE             1
#define MENU_SENDING_DISPLAY    2
#define MENU_SENDING            3
#define SET_ID                  4
 
Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial pc(USBTX, USBRX);
CAN can1(p9, p10);
CAN can2(p30, p29);

char value = 0;
uint8_t state = 0;
uint16_t identifier = 0x0539;
uint8_t bytes;
char message[8];

void send() {
    //pc.printf("send()\n");
    if(can1.write(CANMessage(identifier, message, bytes,CANRemote))) {
        //pc.printf("wloop()\n");
        //counter++;
        pc.printf("Message sent: %d\r\n", message);
    } 
    led1 = !led1;
}
 
int main() {
    
    //ticker.attach(&send, 1);
    CANMessage msg;
    char c;
    uint64_t instruction;
    
    
    int8_t state_val;
    uint8_t data_report[100];
    uint8_t data_rc;
    uint8_t endianness = 0;
    while(1) {
       
       
       
       
    switch(state){
       
       case MENU_DISPLAY://menu affichage
       pc.printf("\r\n\n\n");
       pc.printf("CAN BUS - TERMINAL \r\n");
       pc.printf("1 - Set the value to be sent\r\n");
       pc.printf("2 - Set Endianness \r\n");
       pc.printf("3 - Set Identifier \r\n");
       pc.printf("4 - Send the value \r\n");
       state = 1;       
       break;
       
       case MENU_CHOOSE://choix menu
       
       c = pc.getc();
       
       
       if(c == '1'){//attribution valeur a envoyer
        instruction = 0;
        state_val = 0;
        pc.printf("1 \r\n\n");
        wait(1.0);
        state = MENU_SENDING_DISPLAY;
        }
        
        
        if(c == '2'){
            pc.printf("2 \r\n\n");
        wait(1.0);
            
            pc.printf("Endianness Configuration \r\n");
            pc.printf("1 - Choose Big/Little Endian \r\n");
            pc.printf("2 - Back to menu \r\n");
            
            c = pc.getc();
            
            if(c == '1'){
                endianness = BIG_ENDIAN;
                instruction = message[0];
                message[0] = message[1];
                pc.printf("\r\n1\r\n");
                }
                
                if(c == '2'){
                endianness = LITTLE_ENDIAN;
                instruction = message[0];
                message[0] = message[1];
                pc.printf("\r\n2\r\n");
                }
            state = MENU_DISPLAY;
            wait(1.0);
            
            }
        

    if(c == '3'){
        
        pc.printf("3 \r\n\n");
        wait(1.0);
        
        pc.printf("Set the identifier(hexa) : 0x");
        state = SET_ID;
         
    }        


        if(c == '4'){//envoie valeur
        pc.printf("4 \r\n\n");
        wait(1.0);
        send();
        /*
        switch(bytes){//calcul nombre octet présent
              case 1://si 1 octet present envoie 1 octet 
        send();
            break;
            
            case 2://si 2 octets present envoie 2 octets 1 par 1
            if(endianness == BIG_ENDIAN){
           // send(instruction_2);
            send();
            }
            
            if(endianness == LITTLE_ENDIAN){
            //send(instruction);
            //send(instruction_2);
            }
            break;
            
            }//switch
            */
            
        state = MENU_DISPLAY; //on revient au menu de départ apres la capture de données
        
        //sequence de capture de données de retour
    for(int i = 0; i <= 500; i++){
            if(!can1.read(msg)) {
            pc.printf("awaiting data\r\n");}
            
            if(can1.read(msg)) {
            pc.printf("Message received: %d \r\n", msg.data[0]);
            data_report[data_rc] = msg.data[0];
            data_rc++;
            led2 = !led2;
             wait(0.1);
        } 

        }//for int i  
        pc.printf("\r\nDone\r\n\n");
        //capture de données terminées, on fait un rapport des données collectées        
        for(int i = 0; i < data_rc; i++){
            pc.printf("Message captured: %d \r\n", data_report[i]);
            }
            data_rc = 0;
        
            }//if c == '2'
       
       break;//
       
       case MENU_SENDING_DISPLAY://choix de la valeur a envoyer
       pc.printf("Set the value to be sent(hex value) : 0x");
       state = 3;       
       break;
       
       case MENU_SENDING://demande de valeur a envoyer
       
       c = pc.getc();
       
       
       //state_val correspond a la premiere valeur, si la premiere valeur n'est pas encore entrée, elle attribué a la variable instruction 
       //dans l'autre cas, on décale de 4 rang les 4 bits de l'ancienne valeur pour l'ajouter à la nouvelle
       switch(c){
           
           
                
           case '0':
           pc.printf("0");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0000;
                }
           
           if(state_val == 0){
               instruction = 0b0000;
               state_val++;
               }
            
           break;
           
           case '1':
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0001;
                }
                
           pc.printf("1");
           if(state_val == 0){
               instruction = 0b0001;
               state_val++;
               }
            
           break;
           
           case '2':
           
            if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0010;
                }
                
           pc.printf("2");
           if(state_val == 0){
               instruction = 0b0010;
               state_val++;
               }
           
           break;
           
           case '3':
           pc.printf("3");
          
          if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0011;
                }
          
           if(state_val == 0){
               instruction = 0b0011;
               state_val++;
               }
            
           break;
           
           case '4':
           
            if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0100;
                }           
           
           pc.printf("4");
           if(state_val == 0){
               instruction = 0b0100;
               state_val++;
               }

           break;
           
           case '5':
           pc.printf("5");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0101;
                }
           
           if(state_val == 0){
               instruction = 0b0101;
               state_val++;
               }
            
           break;
           
           case '6':
           pc.printf("6");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0110;
                }
           
           if(state_val == 0){
               instruction = 0b0110;
               state_val++;
               }
            
           break;
           
           case '7':
           pc.printf("7");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b0111;
                }
           
           if(state_val == 0){
               instruction = 0b0111;
               state_val++;
               }
            
           break;
           
           case '8':
           pc.printf("8");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1000;
                }
           
           
           if(state_val == 0){
               instruction = 0b1000;
               state_val++;
               }
            
           break;
           
           case '9':
           pc.printf("9");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1001;
                }
           
           if(state_val == 0){
               instruction = 0b1001;
               state_val++;
               }
            
           break;
           
           case 'a':
           pc.printf("a");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1010;
                }
           
           if(state_val == 0){
               instruction = 0b1010;
               state_val++;
               }
            
           break;
           
           case 'b':
           pc.printf("b");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1011;
                }
           
           if(state_val == 0){
               instruction = 0b1011;
               state_val++;
               }
            
           break;
           
           case 'c':
           pc.printf("c");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1100;
                }
           
           if(state_val == 0){
               instruction = 0b1100;
               state_val++;
               }
            
           break;
           
           case 'd':
           pc.printf("d");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1101;
                }
           
           if(state_val == 0){
               instruction = 0b1101;
               state_val++;
               }
            
           break;
           
           case 'e':
           pc.printf("e");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1110;
                }
           
           if(state_val == 0){
               instruction = 0b1110;
               state_val++;
               }
            
           break;
           
           case 'f':
           pc.printf("f");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1111;
                }
           
           if(state_val == 0){
               instruction = 0b1111;
               state_val++;
               }
            
           break;
           
           case 'A':
           pc.printf("a");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1010;
                }
           
           if(state_val == 0){
               instruction = 0b1010;
               state_val++;
               }
            
           break;
           
           case 'B':
           pc.printf("b");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1011;
                }
           
           if(state_val == 0){
               instruction = 0b1011;
               state_val++;
               }
            
           break;
           
           case 'C':
           pc.printf("c");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1100;
                }
           
           if(state_val == 0){
               instruction = 0b1100;
               state_val++;
               }
            
           break;
           
           case 'D':
           pc.printf("d");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1101;
                }
           
           if(state_val == 0){
               instruction = 0b1101;
               state_val++;
               }
            
           break;
           
           case 'E':
           pc.printf("e");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1110;
                }
           
           if(state_val == 0){
               instruction = 0b1110;
               state_val++;
               }
            
           break;
           
           case 'F':
           pc.printf("f");
           
           if(state_val > 0){
                instruction = instruction << 4;
                instruction |= 0b1111;
                }
           
           if(state_val == 0){
               instruction = 0b1111;
               state_val++;
               }
            
           break;
           
           case '\r': //si au sérial nous avons le retour de ligne
           pc.printf("\r\Done \r\n");
           wait(1.0);
           state_val = 0;
           state = MENU_DISPLAY;
           //calcul du nombre d'octet en fonction de la valeur finale
           if(instruction <= 0xFF){
               bytes = 1;
               message[0] = instruction;
               message[1] = 0;
               message[2] = 0;
               message[3] = 0;
               message[4] = 0;
               message[5] = 0;
               message[6] = 0;
               message[7] = 0;
               
               }
               if(instruction > 0xFF && instruction <= 0xFFFF){
               bytes = 2;
               message[1] = instruction & 0x00FF;
               instruction = instruction >> 8;
               message[0] = instruction;
               message[2] = 0;
               message[3] = 0;
               message[4] = 0;
               message[5] = 0;
               message[6] = 0;
               message[7] = 0;
               }
               if(instruction > 0xFFFF && instruction <= 0xFFFFFF){
               bytes = 3;
               message[2] = instruction & 0x0000FF;
               message[1] = (instruction >> 8) & 0x00FF;
               instruction = instruction >> 16;
               message[0] = instruction & 0xFF;
               message[3] = 0;
               message[4] = 0;
               message[5] = 0;
               message[6] = 0;
               message[7] = 0;
               }
               
               if(instruction > 0xFFFFFF && instruction <= 0xFFFFFFFF){
               bytes = 4;
               message[3] = instruction & 0x000000FF;
               message[2] = (instruction >> 8) & 0x0000FF;
               message[1] = (instruction >> 16) & 0x00FF;
               instruction = instruction >> 24;
               message[0] = instruction & 0xFF;
               message[4] = 0;
               message[5] = 0;
               message[6] = 0;
               message[7] = 0;
               }
               
               if(instruction > 0xFFFFFFFF && instruction <= 0xFFFFFFFFFF){
               bytes = 5;
               message[4] = instruction & 0x00000000FF;
               message[3] = (instruction >> 8) & 0x000000FF;
               message[2] = (instruction >> 16) & 0x0000FF;
               message[1] = (instruction >> 24) & 0x00FF;
               instruction = instruction >> 32;
               message[0] = instruction & 0xFF;
               message[5] = 0;
               message[6] = 0;
               message[7] = 0;
               }
               
               if(instruction > 0xFFFFFFFFFF && instruction <= 0xFFFFFFFFFFFF){
               bytes = 6;
               message[5] = instruction & 0x0000000000FF;
               message[4] = (instruction >> 8) & 0x00000000FF;
               message[3] = (instruction >> 16) & 0x000000FF;
               message[2] = (instruction >> 24) & 0x0000FF;
               message[1] = (instruction >> 32) & 0x00FF;
               instruction = instruction >> 40;
               message[0] = instruction & 0xFF;
               message[6] = 0;
               message[7] = 0;
               }
               
               if(instruction > 0xFFFFFFFFFFFF && instruction <= 0xFFFFFFFFFFFFFF){
               bytes = 7;
               message[6] = instruction & 0x000000000000FF;
               message[5] = (instruction >> 8) & 0x0000000000FF;
               message[4] = (instruction >> 16) & 0x00000000FF;
               message[3] = (instruction >> 24) & 0x000000FF;
               message[2] = (instruction >> 32) & 0x0000FF;
               message[1] = (instruction >> 40) & 0x00FF;
               instruction = instruction >> 48;
               message[0] = instruction & 0xFF;
               message[7] = 0;
               }
               if(instruction > 0xFFFFFFFFFFFFFF && instruction <= 0xFFFFFFFFFFFFFFFF){
               bytes = 8;
               message[7] = instruction & 0x00000000000000FF;
               message[6] = (instruction >> 8) & 0x000000000000FF;
               message[5] = (instruction >> 16) & 0x0000000000FF;
               message[4] = (instruction >> 24) & 0x00000000FF;
               message[3] = (instruction >> 32) & 0x000000FF;
               message[2] = (instruction >> 40) & 0x0000FF;
               message[1] = (instruction >> 48) & 0x00FF;
               instruction = instruction >> 56;
               message[0] = instruction & 0xFF;               
               }
           break;
           
           
           }
       
       break;
       
       case SET_ID:
       
       c = pc.getc();
         
         switch(c){
           
           
                
           case '0':
           pc.printf("0");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0000;
                }
           
           if(state_val == 0){
               identifier = 0b0000;
               state_val++;
               }
            
           break;
           
           case '1':
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0001;
                }
                
           pc.printf("1");
           if(state_val == 0){
               identifier = 0b0001;
               state_val++;
               }
            
           break;
           
           case '2':
           
            if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0010;
                }
                
           pc.printf("2");
           if(state_val == 0){
               identifier = 0b0010;
               state_val++;
               }
           
           break;
           
           case '3':
           pc.printf("3");
          
          if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0011;
                }
          
           if(state_val == 0){
               identifier = 0b0011;
               state_val++;
               }
            
           break;
           
           case '4':
           
            if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0100;
                }           
           
           pc.printf("4");
           if(state_val == 0){
               identifier = 0b0100;
               state_val++;
               }

           break;
           
           case '5':
           pc.printf("5");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0101;
                }
           
           if(state_val == 0){
               identifier = 0b0101;
               state_val++;
               }
            
           break;
           
           case '6':
           pc.printf("6");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0110;
                }
           
           if(state_val == 0){
               identifier = 0b0110;
               state_val++;
               }
            
           break;
           
           case '7':
           pc.printf("7");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b0111;
                }
           
           if(state_val == 0){
               identifier = 0b0111;
               state_val++;
               }
            
           break;
           
           case '8':
           pc.printf("8");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1000;
                }
           
           
           if(state_val == 0){
               identifier = 0b1000;
               state_val++;
               }
            
           break;
           
           case '9':
           pc.printf("9");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1001;
                }
           
           if(state_val == 0){
               identifier = 0b1001;
               state_val++;
               }
            
           break;
           
           case 'a':
           pc.printf("a");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1010;
                }
           
           if(state_val == 0){
               identifier = 0b1010;
               state_val++;
               }
            
           break;
           
           case 'b':
           pc.printf("b");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1011;
                }
           
           if(state_val == 0){
               identifier = 0b1011;
               state_val++;
               }
            
           break;
           
           case 'c':
           pc.printf("c");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1100;
                }
           
           if(state_val == 0){
               identifier = 0b1100;
               state_val++;
               }
            
           break;
           
           case 'd':
           pc.printf("d");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1101;
                }
           
           if(state_val == 0){
               identifier = 0b1101;
               state_val++;
               }
            
           break;
           
           case 'e':
           pc.printf("e");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1110;
                }
           
           if(state_val == 0){
               identifier = 0b1110;
               state_val++;
               }
            
           break;
           
           case 'f':
           pc.printf("f");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1111;
                }
           
           if(state_val == 0){
               identifier = 0b1111;
               state_val++;
               }
            
           break;
           
           case 'A':
           pc.printf("a");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1010;
                }
           
           if(state_val == 0){
               identifier = 0b1010;
               state_val++;
               }
            
           break;
           
           case 'B':
           pc.printf("b");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1011;
                }
           
           if(state_val == 0){
               identifier = 0b1011;
               state_val++;
               }
            
           break;
           
           case 'C':
           pc.printf("c");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1100;
                }
           
           if(state_val == 0){
               identifier = 0b1100;
               state_val++;
               }
            
           break;
           
           case 'D':
           pc.printf("d");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1101;
                }
           
           if(state_val == 0){
               identifier = 0b1101;
               state_val++;
               }
            
           break;
           
           case 'E':
           pc.printf("e");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1110;
                }
           
           if(state_val == 0){
               identifier = 0b1110;
               state_val++;
               }
            
           break;
           
           case 'F':
           pc.printf("f");
           
           if(state_val > 0){
                identifier = identifier << 4;
                identifier |= 0b1111;
                }
           
           if(state_val == 0){
               identifier = 0b1111;
               state_val++;
               }
            
           break;
           
           case '\r': //si au sérial nous avons le retour de ligne
           pc.printf("\r\n0x%x \r\n", identifier);
           wait(1.0);
           state = MENU_DISPLAY;
           state_val = 0;
           break;
           
           
           }
       
       
       break;
       
       
       
       
       }   
       
       
       
        
        //wait(0.2);
    }
}
