
#include "mbed.h"
#include "MFRC522.h"
#include "rtos.h"

//KL25Z Pins for MFRC522 SPI interface
#define SPI_MOSI    p5
#define SPI_MISO    p6
#define SPI_SCLK    p7
#define SPI_CS      p9
// KL25Z Pin for MFRC522 reset
#define MF_RESET    p8
/**
// KL25Z Pins for Debug UART port
#define UART_RX     gnd
#define UART_TX     gnd

Serial     DebugUART(UART_TX, UART_RX);
**/
MFRC522 RfChip(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);
Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut dg0(p27);
DigitalOut dg1(p28);
DigitalOut dg2(p29);
DigitalOut dg3(p30);

DigitalOut da(p26);
DigitalOut db(p25);
DigitalOut dc(p24);
DigitalOut dd(p23);
DigitalOut de(p22);
DigitalOut df(p21);
DigitalOut dg(p19);
DigitalOut ddp(p18);

AnalogIn a0(p20);

DigitalOut IN1(p11);
DigitalOut IN2(p12);
DigitalOut IN3(p13);
DigitalOut IN4(p14);

DigitalIn  POWER(p17);

float sensorValue = 0.0000;

int speedcontrol = 0.00001;

bool loggedIn = 0;

int sevenSeg;

void light7Seg(int nr, int output) {
    da = 0;
    db = 0;
    dc = 0;
    dd = 0;
    de = 0;
    df = 0;
    dg = 0;
    ddp = 0;
    dg0 = 1;
    dg1 = 1;
    dg2 = 1;
    dg3 = 1;
    switch(output) {
        case 0:
            dg0 = 0;
            break;
        case 1:
            dg1 = 0;
            break;
        case 2:
            dg2 = 0;
            break;
        case 3:
            dg3 = 0;
            ddp = 1;
            break;
        default:
            break;
    }
    switch(nr) {
        case 0:
            da = 1;
            db = 1;
            dc = 1;
            dd = 1;
            de = 1;
            df = 1;
            dg = 0;
            break;
        case 1:
            da = 0;
            db = 1;
            dc = 1;
            dd = 0;
            de = 0;
            df = 0;
            dg = 0;
            break;
        case 2:
            da = 1;
            db = 1;
            dc = 0;
            dd = 1;
            de = 1;
            df = 0;
            dg = 1;
            break;
        case 3:
            da = 1;
            db = 1;
            dc = 1;
            dd = 1;
            de = 0;
            df = 0;
            dg = 1;
            break;
        case 4:
            da = 0;
            db = 1;
            dc = 1;
            dd = 0;
            de = 0;
            df = 1;
            dg = 1;
            break;
        case 5:
            da = 1;
            db = 0;
            dc = 1;
            dd = 1;
            de = 0;
            df = 1;
            dg = 1;
            break;
        case 6:
            da = 1;
            db = 0;
            dc = 1;
            dd = 1;
            de = 1;
            df = 1;
            dg = 1;
            break;
        case 7:
            da = 1;
            db = 1;
            dc = 1;
            dd = 0;
            de = 0;
            df = 0;
            dg = 0;
            break;
        case 8:
            da = 1;
            db = 1;
            dc = 1;
            dd = 1;
            de = 1;
            df = 1;
            dg = 1;
            break;
        case 9:
            da = 1;
            db = 1;
            dc = 1;
            dd = 1;
            de = 0;
            df = 1;
            dg = 1;
            break;
        case 10:
            da = 1;
            db = 1;
            dc = 1;
            dd = 0;
            de = 1;
            df = 1;
            dg = 1;
            break;
        case 11:
            da = 0;
            db = 0;
            dc = 1;
            dd = 1;
            de = 1;
            df = 1;
            dg = 1;
            break;
        case 12:
            da = 1;
            db = 0;
            dc = 0;
            dd = 1;
            de = 1;
            df = 1;
            dg = 0;
            break;
        case 13:
            da = 0;
            db = 1;
            dc = 1;
            dd = 1;
            de = 1;
            df = 0;
            dg = 1;
            break;
        case 14:
            da = 1;
            db = 0;
            dc = 0;
            dd = 1;
            de = 1;
            df = 1;
            dg = 1;
            break;
        case 15:
            da = 1;
            db = 0;
            dc = 0;
            dd = 0;
            de = 1;
            df = 1;
            dg = 1;
            break;
        default:
            da = 0;
            db = 0;
            dc = 0;
            dd = 0;
            de = 0;
            df = 0;
            dg = 0;
            ddp = 0;     
    }
}

void control() {
    while (true) {
        led1 = IN1;
        led2 = IN2;
        led3 = IN3;
        led4 = IN4;    
    }    
}

void motorControl() {
    while(true) {
        bool PWR = POWER.read();
        if(loggedIn == 1 && PWR == 1) {
            IN1 = 1;
            IN2 = 0;
            IN3 = 1;
            IN4 = 0;
            
            //Thread::wait(speedcontrol - speedcontrol/sensorValue);
            Thread::wait(100-100*sensorValue);
            
            IN1 = 1;
            IN2 = 0;
            IN3 = 0;
            IN4 = 1;
            
            //Thread::wait(speedcontrol - speedcontrol/sensorValue);
            Thread::wait(100-100*sensorValue);
            
            IN1 = 0;
            IN2 = 1;
            IN3 = 0;
            IN4 = 1;
            
            //Thread::wait(speedcontrol - speedcontrol/sensorValue);
            Thread::wait(100-100*sensorValue);
            
            IN1 = 0;
            IN2 = 1;
            IN3 = 1;
            IN4 = 0;
            
            //Thread::wait(speedcontrol - speedcontrol/sensorValue);
            Thread::wait(100-100*sensorValue);
        } else {
            Thread::wait(100);
        }
    }
}

void displayNumber7Seg() {
    while (true) {
        float nr = sensorValue;
        nr *= 1000;
        int nrint = (int) nr;
        int digits[4];
        int i = 3;
        while (nrint >= 0) {
            int digit = nrint % 10;
            digits[i] = digit;
            if(i == 0) {
                break;    
            }
            --i;
            nrint /= 10;
        }    
        for(int i = 0; i < 4; i++) {
            light7Seg(digits[3-i], i);
            Thread::wait(100/24); //60Hz
        }
    }
}

void samplePotentio() {
    while (true) {
        float samples[20];
        float sum = 0;
        for(int i = 0; i < 20; i++) {
            samples[i] = a0.read();
            Thread::wait(5);
        }
        for (int i = 0; i < 20; i++) {
            sum = sum + samples[i];
        }
        sensorValue = sum / 20;
    }
}


void checkRFID() {
  pc.printf("start rfid");
  uint8_t mastercard [] = {0x04, 0x89, 0x39, 0x1a, 0xee, 0x32, 0x80};
  bool mastercardFound = 0;
  // Init. RC522 Chip
  RfChip.PCD_Init();
  while (true) {  

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      Thread::wait(500);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      Thread::wait(500);
      continue;
    }

    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      led2 = 1;
      pc.printf("card: %02x ", RfChip.uid.uidByte[i]);
      pc.printf("master: %02x ", mastercard[i]);
      if (RfChip.uid.uidByte[i] != mastercard[i]) {
          mastercardFound = 0;
          break;
      } else {
          mastercardFound = 1;
      }
    }
    pc.printf("\r\n");

    led3 = 1;
    
    if (mastercardFound == 1) {
        led4 = 1;
        loggedIn = !loggedIn;
        led1 = loggedIn;
    }
    Thread::wait(1000);
    led2 = 0;
    led3 = 0;
    led4 = 0;
  }
}
    

int main(void) {
  pc.printf("Start");
  
  Thread thread_sample;
  thread_sample.start(samplePotentio);
  
  /*Thread thread_control;
  thread_control.start(control);*/
   
  Thread thread_motor(osPriorityRealtime);
  thread_motor.start(motorControl);
  
  Thread thread_display(osPriorityRealtime);
  thread_display.start(displayNumber7Seg);
  
  Thread thread_rfid;
  thread_rfid.start(checkRFID);
  // Set debug UART speed
  //pc.baud(115200);
  
    dg0 = 0;
    dg1 = 0;
    dg2 = 0;
    dg3 = 0;

  while (true) {  

    // Look for new cards
    /*if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }

    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      led = 1;
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    pc.printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
  }*/
}
}




