//RFID-RC522 
//Bazirano na Martin Olejar's MFRC522 library.

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                              
                              
#include "mbed.h"
#include "MFRC522.h"



DigitalOut LedGreen(LED1);

//Serial connection to PC for output
Serial pc(USBTX, USBRX);

MFRC522    RfChip   (p5,p6,p7,p8,p9);

int main(void) {
  uint8_t test [4];
  pc.printf("starting...\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {
    LedGreen = 1;

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
    
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }

    LedGreen = 0;

    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %0X02", RfChip.uid.uidByte[i]);
      
    }
    pc.printf("\n\r");
    if(RfChip.uid.uidByte[0]==23)
      {
        pc.printf("dobra\n");
      }
    else if(RfChip.uid.uidByte[0]!=23)
    {
        pc.printf("kriva\n");
    }
    wait_ms(1000);
  }
}
