#include "mbed.h"
#include "rtos.h

PwmOut pwm1(p21);       //Servo Motor-1 PWM channel
PwmOut pwm2(p22);       //Servo Motor-2 PWM channel

DigitalOut dc1(p5);     //DC motor input-1
DigitalOut dc2(p6);     //DC motor input-2
PwmOut pwm3(p23);       //DC motor PWM channel

AnalogIn button(p15);   //Analog input from the floor buttons
InterruptIn event(p7);  //Interrupt for rising and falling edge detection from IR

Timer timer;            //Timer to read falling and rising edge time
Timer timer2;
Serial pc(USBTX, USBRX);//Serial Communication

//Functions
void openGate();
void closeGate();
void rising();
void falling();
void read_button(void const *args);
void addtoarray(int val);
int getState(float adc_val);

//Global variables
int begin,end = 0;
int dir = 1; // 1 is up and 0 is down
int destinationState = 1; // Destination floor
int currentState = 1; //Current floorfloat frequency = 0;

//Global arrays
int fvalues[] = {0,100,250,500,700,1000};
int press[4]; // to store the total number of keypresses


int main() {
    
    int val;
    int i,temp =0;
    int flag_up =0;
    int flag_down =0;
    
    press[0] = 0;
    press[1] = 0;
    press[2] = 0;
    press[3] = 0;
    
    timer.start();
    event.rise(&rising);
    event.fall(&falling);
    
    //Setting dc1 to high and dc2 to low initially
    dc1 = 0;
    dc2 = 1;

    //Setting the period and duty cycle for DC motors
    pwm3.period_ms(20);
    pwm3.write(0);    
    
    //Setting the period and duty cycle for Servo motors
    pwm1.period_ms(20);
    pwm2.period_ms(20);
    pwm1.write(0);
    pwm2.write(0);
    
    Thread thread(read_button);
    
    while(1){
        
        // Take the first element if not empty    
        if(press[0] > 0)              
                val = press[0];   
        else
            continue;
               
        // Ignore if new pressed floor is same as current floor
        // Remove the first value and left shift
        if(val == currentState || val == 0){
            pwm3.write(0);
            press[0] = press[1];
            press[1] = press[2];
            press[2] = press[3];
            press[3] = 0; 
            continue;
        }
        
        
        
                dir = 1;
                flag_up = 1;
                
                while(dir == 1){
               
                        closeGate(); //Close gate
                        printf("Moving up\n\n\n");
                        printf("Destination Floor: %d\n",val);
                        printf("Current Floor: %d\n",currentState);
 
                        dc1 = 0;
                        dc2 = 1;
                        pwm3.write(0.1);
                        printf("Destination Floor Frequency value:%d\n",fvalues[val]);
                        
                        while(1){
                                if(((frequency > (fvalues[val] - 10)) && (frequency < (fvalues[val] + 10)))){
                                    currentState = val;
                                    openGate();
                                    break;
                                }
                                //else{
                                //    printf("current freq: %f\n",frequency);
                                //}
                        }
                        
                        //Check for any key presses greater than current floor
                        for(i=0; i<4 ;i++){
                            
                                if(press[i]> 0 && press[i] > currentState ){
                                    val = press[i];
                                    press[i] = 0;
                                    flag_up = 1;
                                    break;             
                                }
                        }
                        
                        if(flag_up == 0)
                            break;
                            
                  } //end of while dir
                
        
        
                dir = 0;
                flag_down = 1;
                
                while(dir == 0){
               
                        closeGate(); //Close gate
                        printf("Moving down\n\n\n");
                        printf("Destination Floor: %d\n",val);
                        printf("Current Floor: %d\n",currentState);
                        dc1 = 1;
                        dc2 = 0;
                        pwm3.write(0.1);
                        printf("Destination Floor Frequency value:%d\n",fvalues[val]);
                        
                        while(1){
                                if(((frequency > (fvalues[val] - 10)) && (frequency < (fvalues[val] + 10)))){
                                    currentState = val;
                                    openGate();
                                    break;
                                }
                                //else{
                                //    printf("current freq: %f\n",frequency);
                                //}
                        }
                        
                        //Check for any key presses lesser than current floor
                        for(i=4; i>=0 ;i++){
                            
                                if(press[i]> 0 && press[i] < currentState ){
                                    val = press[i];
                                    press[i] = 0;
                                    flag_down = 1;
                                    break;             
                                }
                        }
                        
                        if(flag_down == 0)
                            break;
                } //end of while dir
                
    }//end of outer while 1
    
} //end of main




//Function to read the key pressed and store in array
void read_button(void const *args) {
    
    int i,prev_val,val = 0;
    printf("Entered thread\n");
    
    while (1) {
         
        if (press[3] == 0){   // Enter only if array is not full                     
            
            //float adc_val = button.read();
            //int val = getState(adc_val);                          
            char c = pc.getc();
            val = c - 48;
            printf("value entered : %d\n",val);
            
            if(val!= prev_val){ // If new floor is pressed
                
                prev_val = val; // Modify the previous value  
    
                if(dir == 1){ // If lift is goin up - check if read value is less than current destination                
                    if((val < destinationState)){ // If the value is less than destination floor make the current value as destination
                        addtoarray(destintionState);
                        destintionState = val;   
                    }
                    else{ //if the value is greater than the destination, add it to the list 
                        addtoarray(val);
                    }
                }
                
                else if(dir == 0){ // If the lift is going down - check if read value is greater than current destination
                    if((val > destinationState)){ // If the value is less than destination floor make the current value as destination
                        addtoarray(destintionState);
                        destintionState = val;   
                    }
                    else{ //if the value is lesser than the destination, add it to the list 
                        addtoarray(val);
                    }
                }            
            }
        }      
    }
}



//Funtion to remove first element in the array
void removefirst(){
    press[0] = 0;
    press[1] = press[2];
    press[2] = press[3];
    press[3] = press[4];
}

//Function to add to array at the back
void addtoarray(int val){   

int i;

    if(press[3] == 0){ //insert only if array is not full
    
        for(i=0;i<4;i++){
            if(press[i] != 0){
                press[i] = val;
                break;        
            }
        }
    ]
    else
        printf("The array is full\n");
}
    
// Function to open gates
void openGate(){
    pwm1.write(0.0375); // 3.75% duty cycle - Open the gate
    pwm2.write(0.1125);
    wait(2);
    pwm1.write(0);      // Stop
    pwm2.write(0);
}

// Function to close gates
void closeGate(){
    pwm1.write(0.1125); // 11.25% duty cycle - Close the gate
    pwm2.write(0.0375);
    wait(2);
    pwm1.write(0);      // Stop
    pwm2.write(0); 
}

// Funciton to get floor based on keypress voltage
int getState(float adc_val){
    int state;
        
    if(adc_val > 0.15 && adc_val < 0.25){
        state = 2;
        printf("Button Press : %d\n",state);
    }
    else if(adc_val > 0.35 && adc_val < 0.45){
        state = 1;
        printf("Button Press : %d\n",state);
    }
    else if(adc_val > 0.55 && adc_val < 0.65){
        state = 3;
        printf("Button Press : %d\n",state);
    }
    else if(adc_val > 0.75 && adc_val < 0.85){
        state = 4;
        printf("Button Press : %d\n",state);
    }
    else if(adc_val > 0.95 && adc_val < 1.05){
        state = 5;
        printf("Button Press : %d\n",state);
    }

    return state;           
}


// Function to check for rising edge
void rising(){
    begin = timer.read_us();
    flag = true;
}


// Function to check for falling edge
void falling(){
    if(flag == true){
        end = timer.read_us();
        frequency = 500000/(end-begin);
        begin = 0;
        end = 0;
        flag = false;
    }
}



//Extra Stuff

 
/*
//Sorting the array
printf("sorting array\n");
    for (a = 0; a < 4; a++){
        for (b = a + 1; b < 4; b++){
            if (press[a] > 0 && press[b] > 0 && press[a] > press[b]){
                temp =  press[a];
                press[a] = press[b];
                press[b] = temp;
            }
        }
    }
*/            


/*
//if(press[3] > 0){
//printf("Queue size exceeded\n");
//}
*/        