#include "mbed.h"
#include "rtos.h"
PwmOut pwm1(p21);       //Servo Motor-1 PWM channel
PwmOut pwm2(p22);       //Servo Motor-2 PWM channel
 
DigitalOut dc1(p5);     //DC motor input-1
DigitalOut dc2(p6);     //DC motor input-2
PwmOut pwm3(p23);       //DC motor PWM channel
 
AnalogIn button(p15);   //Analog input from the floor buttons
InterruptIn event(p7);  //Interrupt for rising and falling edge detection from IR
 
Timer timer;            //Timer to read falling and rising edge time
 
Serial pc(USBTX, USBRX);//Serial Communication
 
void openGate();
void closeGate();
void rising();
void falling();
 void read_button(void const *args);
int getState(float adc_val);
 
int currentState = 1;
int destinationState = 1;
int begin,end = 0;
float frequency = 0;
bool flag = false;
int fvalues[] = {0,100,250,500,700,1000};
//int fvalues[] = {0,102,270,615,948,1623};
int buttonStatus[] = {0,0,0,0,0,0};
int gateCheck = 1;   //1 for OPEN and 0 for CLOSED
int direction  = 1;  //1 for UP, 0 for DOWN
 
int main() {
    timer.start();
    event.rise(&rising);
    event.fall(&falling);
    //Setting dc1 to high and dc2 to low initially
    dc1 = 0;
    dc2 = 1;
    pwm3.period_ms(20);
    pwm3.write(0);
    
    //Setting the period and duty cycle for Servo motors
    pwm1.period_ms(20);
    pwm2.period_ms(20);
    pwm1.write(0);
    pwm2.write(0);
    Thread thread(read_button);
    openGate();
    while(1){
        int i = 0;
        //printf("Frequency:-%f\n", frequency);
        //char c = pc.getc();
        //destinationState = c - 48;
        //float adc_val = button.read();
        //destinationState = getState(adc_val);
        //printf("Current Floor : %d\n",currentState);
        //printf("Destination Floor :%d\n",destinationState);
        
        if(destinationState==currentState){
            pwm3.write(0);
            //Scanning
            for(i=1;i<5;i++){
                int value = (currentState + i)%5;
                if(value==0){
                    value = 5;
                }
                if(buttonStatus[value]){
                    if(value > currentState){
                        direction = 1;
                    }
                    else{
                        direction = 0;
                    }
                    break;
                }
            }
        }
        else if(destinationState > currentState){
            for(i=currentState+1;i<=destinationState;i++){
                if(gateCheck){
                    closeGate(); //Close gate
                }
                //Move Up
                direction = 1;
                dc1 = 0;
                dc2 = 1;
                pwm3.write(0.15);
                printf("Floor Frequency value:%d\n",fvalues[i]);
                while(1){
                    if(((frequency > (fvalues[i] - 20)) && (frequency < (fvalues[i] + 20)))){
                        //Check if buttonStatus = 1
                        if(buttonStatus[i]){
                            pwm3.write(0);
                            openGate();
                            gateCheck = 1;
                        }
                        else{
                            gateCheck = 0;
                        }
                        buttonStatus[i] = 0;
                        break;
                    }
                    else{
                        //printf("current freq: %f\n",frequency);
                    }
                }
                if(i == destinationState){
                    currentState = destinationState;
                }
            }   
        }else{
            for(i=currentState-1;i>=destinationState;i--){
                if(gateCheck){
                    closeGate(); //Close gate
                }
                //Move Down
                direction = 0;
                dc1 = 1;
                dc2 = 0;
                pwm3.write(0.15);
                //wait(2);
                printf("Floor Frequency value:-%d\n",fvalues[i]);
                while(1){
                    if(((frequency > (fvalues[i] - 20)) && (frequency < (fvalues[i] + 20)))){
                        if(buttonStatus[i]){ 
                            pwm3.write(0);
                            openGate();
                            gateCheck = 1;
                        }
                        else{
                            gateCheck = 0;
                        }
                        buttonStatus[i] = 0;
                        break;
                    }
                    else{
                        //printf("current freq: %f\n",frequency);
                    }
                }
                if(i == destinationState){
                    currentState = destinationState;
                }
            }
        }
        pwm3.write(0);
    }
}

//Function to read the key pressed and update the buttonStatus array
void read_button(void const *args) {
    int val;
    while (1){
        char c = pc.getc();
        val = c - 48;
        //float adc_val = button.read();
        //val = getState(adc_val);
        printf("Floor:- %d\n",val);
        buttonStatus[val] = 1;
        if(val > destinationState && direction == 1){
            destinationState = val;
            printf("DestinationState:-%d\n",destinationState);
        }
        else if(val < destinationState && direction == 0){
            destinationState = val;    
        }        
    }
}

void openGate(){
    pwm1.write(0.0375); // 3.75% duty cycle - Open the gate
    pwm2.write(0.1125);
    //start_pwm2(1); // 11.25% duty cycle - Open the gate
    wait(2);
    pwm1.write(0);      // Stop
    pwm2.write(0);
}
 
void closeGate(){
    pwm1.write(0.1125); // 11.25% duty cycle - Close the gate
    pwm2.write(0.0375);
    //start_pwm2(0); // 3.75% duty cycle - Close the gate
    wait(2);
    pwm1.write(0);      // Stop
    pwm2.write(0); 
    //start_pwm2(0); // 3.75% duty cycle - Close the gate    
}
 
int getState(float adc_val){
    int state = 1;
    
    if(adc_val > 0.15 && adc_val < 0.25){
        state = 2;
        printf("%d\n",state);
    }
    else if(adc_val > 0.35 && adc_val < 0.45){
        state = 1;
        printf("%d\n",state);
    }
    else if(adc_val > 0.55 && adc_val < 0.65){
        state = 3;
        printf("%d\n",state);
    }
    else if(adc_val > 0.75 && adc_val < 0.85){
        state = 4;
        printf("%d\n",state);
    }
    else if(adc_val > 0.95 && adc_val < 1.05){
        state = 5;
        printf("%d\n",state);
    }
    
    return state;           
}
 
void rising(){
    begin = timer.read_us();
    flag = true;
}
void falling(){
    if(flag == true){
        end = timer.read_us();
        frequency = 500000/(end-begin);
        begin = 0;
        end = 0;
        flag = false;
    }
}