#include "LinearCharacteristics.h"

using namespace std;

LinearCharacteristics::LinearCharacteristics(float k, float offset){    // standard lin characteristics
    this->k = k;
    this->offset = offset;
    this->upper_limit = 9.99e19;        // means unlimited
    this->lower_limit = -9.99e19;
    }
LinearCharacteristics::LinearCharacteristics(float k, float offset,float lim){ // lin characteristics with lower and upper bound
    this->k = k;
    this->offset = offset;
    this->upper_limit = lim;
    this->lower_limit = -lim;
    }
LinearCharacteristics::LinearCharacteristics(float k, float offset,float ulim,float llim){
    this->k = k;
    this->offset = offset;
    this->upper_limit = ulim;
    this->lower_limit = llim;
    }


LinearCharacteristics::~LinearCharacteristics() {} // destructor
    
float LinearCharacteristics::eval(float u){       // evaluate
    float val = k * (u-offset);
    if(val > upper_limit)
        return upper_limit;
    else if(val < lower_limit)
        return lower_limit;
    else
        return val;
    }
    
