#include "LinearCharacteristics.h"

using namespace std;

LinearCharacteristics::LinearCharacteristics(float k, float offset){
    this->k = k;
    this->offset = offset;
    this->upper_limit = 9.99e19;
    this->lower_limit = -9.99e19;
    }
LinearCharacteristics::LinearCharacteristics(float k, float offset,float lim){
    this->k = k;
    this->offset = offset;
    this->upper_limit = lim;
    this->lower_limit = -lim;
    }
LinearCharacteristics::LinearCharacteristics(float k, float offset,float ulim,float llim){
    this->k = k;
    this->offset = offset;
    this->upper_limit = ulim;
    this->lower_limit = llim;
    }


LinearCharacteristics::~LinearCharacteristics() {} 
    
float LinearCharacteristics::eval(float u){
    float val = k * (u-offset);
    if(val > upper_limit)
        return upper_limit;
    else if(val < lower_limit)
        return lower_limit;
    else
        return val;
    }
    
