class PID_Cntrl
{
public:

    PID_Cntrl(float P, float I, float D, float tau_f, float Ts, float uMin, float uMax);

    float operator()(float error) {
        return doStep((double)error);
    }

    virtual     ~PID_Cntrl();

    void        reset(float initValue);
    float       doStep(double error);
    void        set_limits(double ,double );
    float       get_ulimit(void);
    
private:

    double Iold;
    double eold,yold,del;
    double uMax;
    double uMin;
    double Ts;
    double P,I,D;
    double p, Ka;
    void setCoefficients(float P, float I, float D, float tau_f, float Ts);

};