/*

mbed Can-Bus ECU simulator

v1.0 December 2014

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************

*/
//#include "MapleMini.h"
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "ecu_simulator.h"
#include "globals.h"


// pinout for Maple Mini
DigitalIn click(PA_1);   // Button inputs
// pinout for lpc1768
//DigitalIn click(p21);   // Joystick inputs
//DigitalIn right(p22);
//DigitalIn down(p23);
//DigitalIn left(p24);
//DigitalIn up(p25);

ecu_sim sim(CANSPEED_500);     //Create object and set CAN speed
ecu_t ecu;

Ticker timer;

void attime() 
{
    //second_tick = true;
    //myled = !myled;
    led1 = !led1;
}

// Menu defines

//unsigned char menu_state;
//unsigned char canspeed;

int main() 
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    pc.baud(115200);
    
    //Enable Pullup 
    click.mode(PullUp);

    
    pc.printf("\n\nRIXEN Simulator v1.1 \r\n"); 
      
    led1 = 1;
    wait(0.1);
    led2 = 1;
    wait(0.1);
    led3 = 1;
    wait(0.1);
    led4 = 1;
    wait(0.2);
    led1 = 0; led2 = 0; led3 = 0; led4 = 0;
       
    
    wait(1);
    
    //canspeed = CAN500;
    ecu.dtc = false;
    ecu.active_fault = false;
    
    sim.canspeed(CANSPEED_500); 
    
    wait(0.2);
    led1 = 1;
    
    timer.attach(&attime, 1);
    
    while(1)  // Main CAN loop
    {
        sim.request();
        
        if(!click)
        {
            //update_param(DEC);
            if ( ecu.active_fault == true )
            {
                ecu.active_fault = false;
                led4 = 0;               
            } else {
                ecu.active_fault = true;
                led4 = 1;
            } 
            wait(0.1);   //Delay for auto repeat           
        }
        //wait(0.1);   //Delay cause can bus problems
        //led1 = 1;
        //wait(0.1);
        //led1 = 0; 
    }
}
