#ifndef ECU_SIMULATOR_H
#define ECU_SIMULATOR_H

//#define CANSPEED_125      125000        // CAN speed at 125 kbps
//#define CANSPEED_250      250000        // CAN speed at 250 kbps
#define CANSPEED_500      500000        // CAN speed at 500 kbps

 /* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
#define MODE1               0x01        //Show current data
#define MODE2               0x02        //Show freeze frame data
#define MODE3               0x03        //Show stored Diagnostic Trouble Codes
#define MODE4               0x04        //Clear Diagnostic Trouble Codes and stored values

#define PID_SUPPORTED       0x00
#define MONITOR_STATUS      0x01
#define ENGINE_COOLANT_TEMP 0x05
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define O2_VOLTAGE          0x14

#define MODE1_RESPONSE      0x41
#define MODE3_RESPONSE      0x43
#define MODE4_RESPONSE      0x44
#define PID_REQUEST         0x7DF
#define PID_REPLY           0x7E8

#define ESPAR_CMD           0x7A0       // COMMAND ID
#define ESPAR_RES           0x73C       // response id

typedef struct{  
        unsigned char coolant_temp;
        unsigned int engine_rpm;  
        unsigned char throttle_position;
        unsigned char vehicle_speed;
        unsigned int maf_airflow;
        unsigned int o2_voltage;
        unsigned char dtc;
        unsigned char active_fault;
}ecu_t;

extern ecu_t ecu;

namespace mbed { 

class ecu_sim{

    public:

        ecu_sim(int can_speed);
        void canspeed(int can_speed);
        unsigned char request(void);
    
    private: 

        int i;
 
    };
} 



#endif