#ifndef SPL06_01_H
#define SPL06_01_H


#define SPL0601_ADR 0x76

#define PRS_REG     0x00
#define TMP_REG     0x03

#define PRS_CFG     0x06
#define TRS_CFG     0x07
#define MEAS_CFG    0x08

#define CFG_REG     0x09

#define COEF_SRC    0x28

#define PRESS_RD_1_SEC  0x01
#define PRESS_OVER_SMPL 0x00  // single
#define TEMP_RD_RATE_1_SEC 0x83 // 1 per second, single oversmaple
#define MEAS_RATE 0x07

#define CAL_C0 0x10 // 8 bytes of cal

#include "mbed.h"
#include <stdint.h>
#include "wiced_types.h"

PinName const SDA = PB_7;
PinName const SCL = PB_6;

extern  int16_t c0;
extern  int16_t c1;
extern  int32_t c00, c10;
extern  int16_t c01, c11, c20, c21, c30;

void Init_SPL0601();
void DeInit_SPL0601();

int16_t getInt16(uint8_t *importval);
int16_t getInt12IntoInt16(uint8_t* importval, wiced_bool_t leading4Bits);
int32_t getInt20IntoInt32(uint8_t* importval, wiced_bool_t leading4Bits);
int32_t getInt24IntoInt32(uint8_t* importval);
wiced_bool_t getPressure(double* result);
#endif
