#ifndef __HEATCONTROL_H
#define __HEATCONTROL_H
#include "stdint.h"
#include "wiced_types.h"


#define HEATFAULTCYCLELENGTH 102
#define HEATFAULTCYCLEHOLDOFF -240


typedef enum {HEATCALLOFF=0, HEATCALLON=1, HEATCALLINIT=2, HEATCALLLONGRUN=3} heatcall;


#define IDLE 0

#define HEATERSTATECOUNT 1
#define RESETHEATTIME 60*60*8; // 8hours
#define LIN_RX_BUFFER_SIZE    64
#define LIN_UART              WICED_UART_2


extern struct sHeatVars heaterState[HEATERSTATECOUNT];

struct sHeatVars {
    int primeFuelPumpCount;
    wiced_bool_t heatCallDetected;
    int heaterDetected;
    wiced_bool_t OBAltitude;
    int initTimer;
    int tasksequence;
    uint16_t currentError; // default FF
    char heatOn; // default 0
    wiced_bool_t primeFuelPump;
    wiced_bool_t altitudeMode;
    uint16_t errorHistory[8];
    unsigned char errorChangeFlag; // default 0
    char heatcontrolstate; // default 0
    int lastRequest;// default = 0;
    int lastResponse;//default = 0;
    int noResponseCount;//default = 0;
    char retryHC;// = 0;
    char heatrunning;// = 0;
    char reset_fault_codes; // WICED_FALSE
    wiced_bool_t isAnalogHeater; // wiced_false
    volatile unsigned int tickcount; // default 0
    volatile unsigned int resettick; // default 0
    unsigned char linbuff[35];
    unsigned char linpoint;// = 0;
    unsigned char working;// = 0;
    volatile long heattime; //= 0
    volatile long heatresettime;
    long heaterRuntime;
    unsigned long setpoint;
    char reportflag; //= 0-
    unsigned volatile long preheattime;// = 0;
    unsigned long heaterSetpointChange;
    char bustype;
    char heaternum;
    int battV;
    int altitude;
    int32_t heaterTemp;
    int flameTemp;
    int inletTemp;
    int outletTemp;
    int internalAltitude;
    double rawAltitude;
};


#define HEATERTYPENONE 0
#define HEATERTYPECAN 1
#define HEATERTYPELIN 2

void initHeaterState(struct sHeatVars *s);
void InitLinUart(struct sHeatVars *s);
void InitCAN();
void doHeatTask(struct sHeatVars *s);
void doHeatTaskCAN(struct sHeatVars *s);
void doHeatLogicTask(struct sHeatVars *s);
void WakeHeater(struct sHeatVars *s);


void set_heat_con(struct sHeatVars* s, heatcall on_off);
void show_heat_con(void);
void resetFaultCodes(struct sHeatVars* s);
void primeFuelPump(struct sHeatVars* s);

unsigned char get_heater_fault_code(void);
void get_heater_status_str(char * status);
void setHeatSetpoint(struct sHeatVars* s, int setpoint);

#endif

