/*
 MPL3115A2 Barometric Pressure Sensor Library
 By: Nathan Seidle
 SparkFun Electronics
 Date: September 22nd, 2013
 License: This code is public domain but you buy me a beer if you use this and we meet someday (Beerware license).

 This library allows an Arduino to read from the MPL3115A2 low-cost high-precision pressure sensor.

 If you have feature suggestions or need support please use the github support page: https://github.com/sparkfun/MPL3115A2_Breakout

 Hardware Setup: The MPL3115A2 lives on the I2C bus. Attach the SDA pin to A4, SCL to A5. Use inline 10k resistors
 if you have a 5V board. If you are using the SparkFun breakout board you *do not* need 4.7k pull-up resistors
 on the bus (they are built-in).

 Link to the breakout board product:

 Software:
 .begin() Gets sensor on the I2C bus.
 .readAltitude() Returns float with meters above sealevel. Ex: 1638.94
 .readAltitudeFt() Returns float with feet above sealevel. Ex: 5376.68
 .readPressure() Returns float with barometric pressure in Pa. Ex: 83351.25
 .readTemp() Returns float with current temperature in Celsius. Ex: 23.37
 .readTempF() Returns float with current temperature in Fahrenheit. Ex: 73.96
 .setModeBarometer() Puts the sensor into Pascal measurement mode.
 .setModeAltimeter() Puts the sensor into altimetery mode.
 .setModeStandy() Puts the sensor into Standby mode. Required when changing CTRL1 register.
 .setModeActive() Start taking measurements!
 .setOversampleRate(byte) Sets the # of samples from 1 to 128. See datasheet.
 .enableEventFlags() Sets the fundamental event flags. Required during setup.

 Updated by PaulZC: October 19th, 2019

 */
#include "spl0601.h"


#include "wiced_types.h"
#include "i2c_base.h"
//extern wiced_mutex_t i2c_mutex;
extern char printbuff[256];
extern void DebugWrite(const char* str);

#define SPL0601_ADR 0x76

static int i2cfailcount = 0;

int16_t c0;
int16_t c1;
int32_t c00, c10;
int16_t c01, c11, c20, c21, c30;

I2C* spl_i2c;

/*
const wiced_i2c_device_t i2c_SPL0601 =
{ .port = WICED_I2C_1, //WICED_I2C_1,
        .address = SPL0601_ADR,
        .address_width = I2C_ADDRESS_WIDTH_7BIT,
        .speed_mode = I2C_HIGH_SPEED_MODE, };
*/



void DeInit_SPL0601()
{

    wiced_result_t result;
    /* Init I2C master on the master CPU */
//    wiced_rtos_lock_mutex(&i2c_mutex);
//    result = wiced_i2c_deinit(&i2c_SPL0601);
//    wiced_rtos_unlock_mutex(&i2c_mutex);
//   if (result != WICED_SUCCESS)
//    {
//       printf("I2C Init failed\n\r");
//   }
}
void Init_SPL0601()
{
//    wiced_result_t result;
    /* Init I2C master on the master CPU */
//    wiced_rtos_lock_mutex(&i2c_mutex);
//    result = wiced_i2c_init(&i2c_SPL0601);
//    wiced_rtos_unlock_mutex(&i2c_mutex);
//    if (result != WICED_SUCCESS)
//    {
//        printf("I2C Init failed\n\r");
//   }
}

wiced_bool_t getPressure(double* result)
{
    wiced_result_t queryresult;
    uint8_t buff[20];
    double temperature = 0;
    double prawsc;

    int tempreg;
    double c0d;
    int32_t presreg;
    double trawsc;
    buff[0] = 0x03;
    queryresult = writeRegs(PRS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE);
    if (queryresult != WICED_SUCCESS) {
        return WICED_FALSE;
    }
    readRegs(PRS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);

//             sprintf(printbuff, "PRS_CFG is %02X\r\n", buff[0]);
//           DebugWrite(printbuff);

    readRegs(COEF_SRC, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);
//             sprintf(printbuff, "COEF_SRC is %02X\r\n", buff[0]);
//             DebugWrite(printbuff);

    buff[0] = TEMP_RD_RATE_1_SEC;
    writeRegs(TRS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE);
    readRegs(TRS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);
//             sprintf(printbuff, "TRS_CFG is %02X\r\n", buff[0]);
//             DebugWrite(printbuff);

    buff[0] = 0;
    writeRegs(CFG_REG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE);
    readRegs(CFG_REG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);
//              sprintf(printbuff, "CFG_REG is %02X\r\n", buff[0]);
    //            DebugWrite(printbuff);

    buff[0] = MEAS_RATE;
    writeRegs(MEAS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE);
    readRegs(MEAS_CFG, buff, 1, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);
//    sprintf(printbuff, "MEAS_CFG is %02X\r\n", buff[0]);
//    DebugWrite(printbuff);

    readRegs(CAL_C0, buff, 18, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);
//    sprintf(printbuff, "all cal: is is %02X %02X %02X %02X %02X %02X %02X %02X|%02X %02X %02X %02X %02X %02X %02X %02X|%02X %02X\r\n", buff[0],
  //          buff[1], buff[2], buff[3], buff[4], buff[5], buff[6], buff[7], buff[8], buff[9], buff[10], buff[11], buff[12], buff[13], buff[14],
    //        buff[15], buff[16], buff[17]);
  //  DebugWrite(printbuff);

    c0 = getInt12IntoInt16(buff, WICED_FALSE);
    c1 = getInt12IntoInt16(buff + 1, WICED_TRUE);
    c00 = getInt20IntoInt32(buff + 3, WICED_FALSE);
    c10 = getInt20IntoInt32(buff + 5, WICED_TRUE);
    c01 = getInt16(&buff[8]);
    c11 = getInt16(&buff[10]);
    c20 = getInt16(&buff[12]);
    c21 = getInt16(&buff[14]);
    c30 = getInt16(&buff[16]);

    // 20 byte register, 2s complement
    readRegs(TMP_REG, buff, 3, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);

    tempreg = getInt24IntoInt32(buff);

    c0d = c0;
    c0d = c0d * 0.5;

    // 212530/
    trawsc = tempreg;
    trawsc = trawsc / 7864320;
    temperature = trawsc * c1;

    temperature = c0d + temperature;
 //   sprintf(printbuff, "Temperature is %0.1lf\r\n", temperature);
   // DebugWrite(printbuff);

    readRegs(PRS_REG, buff, 3, spl_i2c, SPL0601_ADR, &i2cfailcount, WICED_FALSE, WICED_FALSE);

    presreg = getInt24IntoInt32(buff);

    prawsc = presreg;
    prawsc = prawsc / 7864320;

    double presComp;
    double prestemp;

    //Pcomp(Pa) = c00 +
    prestemp = c00;
    presComp = prestemp;

    //Praw_sc*(c10 + Praw_sc *(c20+ Praw_sc *c30))
    prestemp = c30;
    prestemp *= prawsc;
    prestemp += c20;
    prestemp *= prawsc;
    prestemp += c10;
    prestemp *= prawsc;
    presComp += prestemp;
    //+ Traw_sc *c01
    prestemp = c01;
    prestemp *= trawsc;
    presComp += prestemp;
    //+ Traw_sc *Praw_sc *(c11+Praw_sc*c21)
    prestemp = c21;
    prestemp *= prawsc;
    prestemp += c11;
    prestemp *= prawsc;
    prestemp *= trawsc;
    presComp += prestemp;
    *result = presComp;
    return WICED_TRUE;
}

int16_t getInt16(uint8_t *importval)
{
    int16_t result = 0;
    for (int i = 0; i < 2; i++) {
        result <<= 8;
        result |= importval[i];
    }
    return result;
}
int16_t getInt12IntoInt16(uint8_t* importval, wiced_bool_t leading4Bits)
{
    int16_t result = 0;
    for (int i = 0; i < 2; i++) {
        result <<= 8;
        result |= importval[i];
    }
    if (!leading4Bits) {
        result >>= 4; // remove trailing nibble
    } else {
        result = result & 0x0FFF; // strip leading nibble
    }
    if ((0x0800 & result) > 0) {
        // negate
        result |= 0xF000;
    }
    return result;
}
int32_t getInt20IntoInt32(uint8_t* importval, wiced_bool_t leading4Bits)
{
    int32_t result = 0;
    for (int i = 0; i < 3; i++) {
        result <<= 8;
        result |= importval[i];
    }
    if (!leading4Bits) {
        result >>= 4; // remove trailing nibble
    } else {
        result = result & 0x000FFFFF; // strip leading nibble
    }
    if ((0x00080000 & result) > 0) {
        // negate
        result |= 0xFFF00000;
    }
    return result;
}
int32_t getInt24IntoInt32(uint8_t* importval)
{
    int32_t result = 0;
    for (int i = 0; i < 3; i++) {
        result <<= 8;
        result |= importval[i];
    }

    if ((0x00800000 & result) > 0) {
        // negate
        result |= 0xFF000000;
    }
    return result;
}


