#include "wiced_types.h"
#include "i2c_base.h"
extern void DebugWrite(const char* str);

void cleanI2CLines(I2C* dev, PinName sda, PinName scl)
{
    delete dev;
    dev = new I2C(sda, scl);
//    wiced_rtos_lock_mutex(&i2c_mutex);
    // toggle
    /*
        int limit = 260;
        while (limit-- > 0)
        {
            wiced_bool_t SDAstate = wiced_gpio_input_get(WICED_GPIO_12);
            wiced_bool_t SCLstate = wiced_gpio_input_get(WICED_GPIO_11);
            wiced_gpio_init(WICED_GPIO_11, OUTPUT_PUSH_PULL);
            wiced_gpio_init(WICED_GPIO_12, INPUT_HIGH_IMPEDANCE);
            //printf("SDA is %d, SCL is %d\r\n", SDAstate, SCLstate);
            if ((SDAstate == WICED_TRUE) && (SCLstate == WICED_TRUE))
            {
                break;
            }
            else
            {
                printf("Pulsing SCL\r\n");
                // pulse SDA
                wiced_gpio_output_low(WICED_GPIO_11);
                wiced_rtos_delay_milliseconds(10);
                wiced_gpio_output_high(WICED_GPIO_11);
                wiced_rtos_delay_milliseconds(10);
            }
        }

        // need to return to input/HI mode or doesn't init properly.
        wiced_gpio_init(WICED_GPIO_11, INPUT_HIGH_IMPEDANCE);
        wiced_gpio_init(WICED_GPIO_12, OUTPUT_OPEN_DRAIN_PULL_UP);
    */
//   wiced_rtos_unlock_mutex(&i2c_mutex);
}

wiced_result_t readRegs(unsigned char addr, unsigned char * data, unsigned char len, I2C* i2c_dev, const int addr7bit, int* failcount, wiced_bool_t writeThenRead,
        wiced_bool_t swap)
{
    int addr8bit = addr7bit << 1;
    int result = 0;
    if (writeThenRead) {
        // not implemented yet
        DebugWrite("Not implemented yet\r\n");
        result = 1;
       
    } else {
         const char t[1] = {addr};
        result = i2c_dev->write(addr8bit, t, 1, true);
        result = i2c_dev->read(addr8bit, (char *)data, len);
    }
    
    if (result > 0) {
        return WICED_ERROR;    
    }
    return WICED_SUCCESS;
}

wiced_result_t writeRegs(unsigned char addr, unsigned char * data, unsigned char len, I2C* i2c_dev, const int addr7bit, int* i2cfailcount, wiced_bool_t swap)
{
    uint8_t command[4];
    int addr8bit = addr7bit << 1;
    int result = 1;
    command[0] = addr;
    if (len == 1)
    {
        command[1] = (data[0] & 0xFF);
    }
    result = i2c_dev->write(addr8bit, (char *)command, len+1);
    if (result > 0) {
        return WICED_ERROR;
    }
    return WICED_SUCCESS;
}
