#include "wiced_types.h"
#include "stdint.h"

#ifndef __ESPAR_CAN_H
#define __ESPAR_CAN_H

// def @OBK_Status_Heater_1 CAN Message (708)
#define OBK_Status_Heater_1_IDE (0U)
#define OBK_Status_Heater_1_DLC (8U)
#define OBK_Status_Heater_1_CANID (0x2C4U)
#define OBK_Status_Heater_1_CYC (200U)
// --  Timeout-Zeit Min-Wert: TMSG_TIMEOUT = 5s  Timeout-Zeit Max-Wert: TMSG_TIMEOUT = 10 * Zykluszeit der Botschaft (Wenn der Wert kleiner als der Min Wert ist wird der Min Wert verwendet)
// signal: @Ist_Temperatur_Heizgeraet_1
#define Ist_Temperatur_Heizgeraet_1_CovFactor 0.1
#define Ist_Temperatur_Heizgeraet_1_CovS(x) ((int32_t)((x / 0.1) + 500))
typedef struct
{

  // 1 - "ja"
  // 0 - "nein"

  uint8_t isValid;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t noHeatModeActive; //kein_Heizbetrieb_aktiv_1;           //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t standbyHeatingActive; //Standheizen_aktiv_1;                //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Standhzn_m_Sollw_u_Isttmp_akt_1;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t standbyHeatingWithSetpointActive; //Standheizen_mit_Sollwert_aktiv_1;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ventilationActive; //Lueften_aktiv_1;                    //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 3 - "nicht_verfuegbar" (disabled)
  // 2 - "verfuegbar" (available)
  // 1 - "Pruefung" (testing)
  // 0 - "nicht_aktiv / don't care"

  uint8_t ResidualHeat;        //      Bits=02.  [ 0     , 3      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Wasserpump_Fremdanstrng_akt_1;      //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t HeatingUpActive;                   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Austritstemp_Reduzierung_akt_1;     //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Nachlauf_aktiv_1;                   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Notlauf_aktiv_1;                    //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t AltitudeModeActive;              //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 3 - "reserviert"
  // 2 - "beendet"
  // 1 - "aktiv"
  // 0 - "nicht_aktiv"

  uint8_t ADR_Abschaltung_1;                  //      Bits=02.  [ 0     , 3      ]  Unit:''

  // 3 - "Taste_klemmt" (key stuck)
  // 2 - "Betaetigung_nicht_erkannt_worden" (actuation not recognised)
  // 1 - "warten_auf_Betaetigung" (waiting for appointment)
  // 0 - "don't care"

  uint8_t Status_ADR_Taste_1;                 //      Bits=02.  [ 0     , 3      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass1;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass2;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass3;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass4;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass5;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass6;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t ErrorClass7;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Angef_Betrbsart_w_nicht_unters_1;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Angf_Betr_nicht_unter_Zuhz_akt_1;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Absch_durch_Diagnosetimeout_1;      //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Timer_Betrieb_nicht_zulaessig_1;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t SetpointInvalid;        //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t Heizgeraet_verriegelt_1;            //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t InvalidConfiguration; //Ungueltige_Konfigurati_erkannt_1;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 65535 - "Fehler"
  // 65534 - "Don't care; Init Wert"

  int32_t HeaterTemperature;        //      Bits=16.  [ -50   , 150    ]  Unit:'?C'    Offset= -50       Factor= 0.1
} OBK_Status_Heater_1_t;

#define NM_Heizgeraet_1_IDE (0U)
#define NM_Heizgeraet_1_DLC (8U)
#define NM_Heizgeraet_1_CANID (0x625U)

typedef struct
{

  uint8_t NM_Byte0_Source_Node_Identifier;    //      Bits=08.  [ 0     , 100    ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit0_Repeat_Msg_Req;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit1_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit2_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit3_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit4_Active_Wakeup;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit5_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit6_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit7_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t HeaterInitFinished;            //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint32_t SerialNumber;            //      Bits=30.  [ 0     , 999999999 ]  Unit:''

  uint8_t HeaterType;           //      Bits=02.  [ 0     , 3      ]  Unit:''

  uint8_t NM_UD3_HG_ADR_Modus_aktiv;          //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t OperateEasyFan;          //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t AltitudeSensorOnBoard;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_UD6_HG_Austritstemp_Red_HG;      //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t OperatingModes;         //      Bits=07.  [ 0     , 6      ]  Unit:''

  uint8_t NM_UD8_HG_Reserviert;               //      Bits=04.  [ 0     , 0      ]  Unit:''
} NM_Heater_1_t;


// def @NM_Bedienelement_K_TP71_1 CAN Message (1551)
#define NM_Bedienelement_K_TP71_1_IDE (0U)
#define NM_Bedienelement_K_TP71_1_DLC (8U)
#define NM_Bedienelement_K_TP71_1_CANID (0x60FU)
typedef struct
{

  uint8_t NM_Byte0_Source_Node_Identifier;    //      Bits=08.  [ 0     , 100    ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit0_Repeat_Msg_Req;   //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit1_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit2_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit3_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit4_Active_Wakeup;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit5_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit6_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_Byte1_CBV_Bit7_reserved;         //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint8_t NM_UD0_BE_init_finished;            //      Bits=01.  [ 0     , 1      ]  Unit:''

  uint32_t NM_UD1_BE_Seriennummer;            //      Bits=30.  [ 0     , 999999999 ]  Unit:''

  // 7 - "reserviert"
  // 6 - "reserviert"
  // 5 - "reserviert"
  // 4 - "E-Control Master"
  // 3 - "E-Control"
  // 2 - "GSM FFB"
  // 1 - "FFB"
  // 0 - "Schaltuhr"

  uint8_t NM_UD2_BE_Typ_Bedienelement;        //      Bits=03.  [ 0     , 7      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t NM_UD3_BE_Fernbedienung;            //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t NM_UD4_BE_ADR_Modus_aktiv;          //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 1 - "ja"
  // 0 - "nein"

  uint8_t NM_UD5_BE_Tempfuehler_vorhanden;    //      Bits=01.  [ 0     , 1      ]  Unit:''

  // 3 - "neu + alt"
  // 2 - "neu"
  // 1 - "alt"
  // 0 - "kein"

  uint8_t NM_UD6_BE_Timervariante;            //      Bits=02.  [ 0     , 3      ]  Unit:''

  uint8_t NM_UD7_BE_Reserviert;               //      Bits=08.  [ 0     , 255    ]  Unit:''

  // 1 - "wird unterst?tzt"
  // 0 - "wird nicht unterst?tzt"

  uint8_t NM_UD8_BE_Steuerung_E_Control_Ma;   //      Bits=01.  [ 0     , 1      ]  Unit:''
} NM_Bedienelement_K_TP71_1_t;


// functions
uint32_t Unpack_OBK_Status_Heater_1_mydbc(OBK_Status_Heater_1_t* _m, const uint8_t* _d, uint8_t dlc_);
uint32_t Unpack_NM_Heater_1_mydbc(NM_Heater_1_t* _m, const uint8_t* _d, uint8_t dlc_);
uint32_t Unpack_NM_Bedienelement_K_TP71_1_mydbc(NM_Bedienelement_K_TP71_1_t* _m, const uint8_t* _d, uint8_t dlc_);


#endif
