#include "espar_can.h"

uint32_t Unpack_NM_Heater_1_mydbc(NM_Heater_1_t* _m, const uint8_t* _d, uint8_t dlc_)
{
  _m->NM_Byte0_Source_Node_Identifier = (_d[0] & (0xFFU));
  _m->NM_Byte1_CBV_Bit0_Repeat_Msg_Req = (_d[1] & (0x01U));
  _m->NM_Byte1_CBV_Bit1_reserved = ((_d[1] >> 1) & (0x01U));
  _m->NM_Byte1_CBV_Bit2_reserved = ((_d[1] >> 2) & (0x01U));
  _m->NM_Byte1_CBV_Bit3_reserved = ((_d[1] >> 3) & (0x01U));
  _m->NM_Byte1_CBV_Bit4_Active_Wakeup = ((_d[1] >> 4) & (0x01U));
  _m->NM_Byte1_CBV_Bit5_reserved = ((_d[1] >> 5) & (0x01U));
  _m->NM_Byte1_CBV_Bit6_reserved = ((_d[1] >> 6) & (0x01U));
  _m->NM_Byte1_CBV_Bit7_reserved = ((_d[1] >> 7) & (0x01U));
  _m->HeaterInitFinished = (_d[2] & (0x01U));
  _m->SerialNumber = ((_d[5] & (0x7FU)) << 23) | ((_d[4] & (0xFFU)) << 15) | ((_d[3] & (0xFFU)) << 7) | ((_d[2] >> 1) & (0x7FU));
  _m->HeaterType = ((_d[6] & (0x01U)) << 1) | ((_d[5] >> 7) & (0x01U));
  _m->NM_UD3_HG_ADR_Modus_aktiv = ((_d[6] >> 1) & (0x01U));
  _m->OperateEasyFan = ((_d[6] >> 2) & (0x01U));
  _m->AltitudeSensorOnBoard = ((_d[6] >> 3) & (0x01U));
  _m->NM_UD6_HG_Austritstemp_Red_HG = ((_d[6] >> 4) & (0x01U));
  _m->OperatingModes = ((_d[7] & (0x0FU)) << 3) | ((_d[6] >> 5) & (0x07U));
  _m->NM_UD8_HG_Reserviert = ((_d[7] >> 4) & (0x0FU));
  return NM_Heizgeraet_1_CANID;
}


uint32_t Unpack_OBK_Status_Heater_1_mydbc(OBK_Status_Heater_1_t* _m, const uint8_t* _d, uint8_t dlc_)
{
  _m->isValid = (_d[0] & (0x01U));
  _m->noHeatModeActive = ((_d[0] >> 1) & (0x01U));
  _m->standbyHeatingActive = ((_d[0] >> 2) & (0x01U));
  _m->Standhzn_m_Sollw_u_Isttmp_akt_1 = ((_d[0] >> 3) & (0x01U));
  _m->standbyHeatingWithSetpointActive = ((_d[0] >> 4) & (0x01U));
  _m->ventilationActive = ((_d[0] >> 5) & (0x01U));
  _m->ResidualHeat = ((_d[0] >> 6) & (0x03U));
  _m->Wasserpump_Fremdanstrng_akt_1 = (_d[1] & (0x01U));
  _m->HeatingUpActive = ((_d[1] >> 1) & (0x01U));
  _m->Austritstemp_Reduzierung_akt_1 = ((_d[1] >> 2) & (0x01U));
  _m->Nachlauf_aktiv_1 = ((_d[1] >> 3) & (0x01U));
  _m->Notlauf_aktiv_1 = ((_d[1] >> 4) & (0x01U));
  _m->AltitudeModeActive = ((_d[1] >> 5) & (0x01U));
  _m->ADR_Abschaltung_1 = ((_d[1] >> 6) & (0x03U));
  _m->Status_ADR_Taste_1 = (_d[2] & (0x03U));
  _m->ErrorClass1 = ((_d[2] >> 2) & (0x01U));
  _m->ErrorClass2 = ((_d[2] >> 3) & (0x01U));
  _m->ErrorClass3 = ((_d[2] >> 4) & (0x01U));
  _m->ErrorClass4 = ((_d[2] >> 5) & (0x01U));
  _m->ErrorClass5 = ((_d[2] >> 6) & (0x01U));
  _m->ErrorClass6 = ((_d[2] >> 7) & (0x01U));
  _m->ErrorClass7 = (_d[3] & (0x01U));
  _m->Angef_Betrbsart_w_nicht_unters_1 = ((_d[3] >> 1) & (0x01U));
  _m->Angf_Betr_nicht_unter_Zuhz_akt_1 = ((_d[3] >> 2) & (0x01U));
  _m->Absch_durch_Diagnosetimeout_1 = ((_d[3] >> 3) & (0x01U));
  _m->Timer_Betrieb_nicht_zulaessig_1 = ((_d[3] >> 4) & (0x01U));
  _m->SetpointInvalid = ((_d[3] >> 5) & (0x01U));
  _m->Heizgeraet_verriegelt_1 = ((_d[3] >> 6) & (0x01U));
  _m->InvalidConfiguration = ((_d[3] >> 7) & (0x01U));
  _m->HeaterTemperature = (((_d[5] & (0xFFU)) << 8) | (_d[4] & (0xFFU))) - 500;
  return OBK_Status_Heater_1_CANID;
}

//{ 0x0D, 0x11, 0xC9, 0x22, 0x00, 0x20, 0x60, 0x00 };

// 1100 1001
uint32_t Unpack_NM_Bedienelement_K_TP71_1_mydbc(NM_Bedienelement_K_TP71_1_t* _m, const uint8_t* _d, uint8_t dlc_)
{
  _m->NM_Byte0_Source_Node_Identifier = (_d[0] & (0xFFU));
  _m->NM_Byte1_CBV_Bit0_Repeat_Msg_Req = (_d[1] & (0x01U));  // enabled
  _m->NM_Byte1_CBV_Bit1_reserved = ((_d[1] >> 1) & (0x01U));
  _m->NM_Byte1_CBV_Bit2_reserved = ((_d[1] >> 2) & (0x01U));
  _m->NM_Byte1_CBV_Bit3_reserved = ((_d[1] >> 3) & (0x01U));
  _m->NM_Byte1_CBV_Bit4_Active_Wakeup = ((_d[1] >> 4) & (0x01U)); // enabled
  _m->NM_Byte1_CBV_Bit5_reserved = ((_d[1] >> 5) & (0x01U));
  _m->NM_Byte1_CBV_Bit6_reserved = ((_d[1] >> 6) & (0x01U));
  _m->NM_Byte1_CBV_Bit7_reserved = ((_d[1] >> 7) & (0x01U));
  _m->NM_UD0_BE_init_finished = (_d[2] & (0x01U));              // enabled
  _m->NM_UD1_BE_Seriennummer = ((_d[5] & (0x7FU)) << 23) | ((_d[4] & (0xFFU)) << 15) | ((_d[3] & (0xFFU)) << 7) | ((_d[2] >> 1) & (0x7FU));
  _m->NM_UD2_BE_Typ_Bedienelement = ((_d[6] & (0x03U)) << 1) | ((_d[5] >> 7) & (0x01U));
  _m->NM_UD3_BE_Fernbedienung = ((_d[6] >> 2) & (0x01U)); // not set
  _m->NM_UD4_BE_ADR_Modus_aktiv = ((_d[6] >> 3) & (0x01U)); // not set
  _m->NM_UD5_BE_Tempfuehler_vorhanden = ((_d[6] >> 4) & (0x01U)); // not set
  _m->NM_UD6_BE_Timervariante = ((_d[6] >> 5) & (0x03U)); // enabled
  _m->NM_UD7_BE_Reserviert = ((_d[7] & (0x7FU)) << 1) | ((_d[6] >> 7) & (0x01U));
  _m->NM_UD8_BE_Steuerung_E_Control_Ma = ((_d[7] >> 7) & (0x01U));
  return NM_Bedienelement_K_TP71_1_CANID;
}
