/*

mbed Can-Bus ECU simulator

v1.0 December 2014

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

********************************************************************************

*/
//#include "MapleMini.h"
#include "stm32f103c8t6.h"
#include "mbed.h"
//#include "ecu_simulator.h"
#include "globals.h"
#include "heatcontrol.h"
#include "spl0601.h"
#include "i2c_base.h"
extern I2C* spl_i2c;
// pinout for Maple Mini
DigitalIn click(PA_1);   // Button inputs
// pinout for lpc1768
//DigitalIn click(p21);   // Joystick inputs
//DigitalIn right(p22);
//DigitalIn down(p23);
//DigitalIn left(p24);
//DigitalIn up(p25);

volatile unsigned long lifetimer = 0;
volatile int secondFlag = 0;

Ticker timer;
Ticker quartersecond_timed_event;
Ticker hundredms_timed_event;
Ticker onesecond_timed_event;

void attime()
{
    //second_tick = true;
    //myled = !myled;
    led1 = 0; // keep it off.  Flicker on with CAN
}

// Menu defines

//unsigned char menu_state;
//unsigned char canspeed;

// external variables
volatile unsigned char idletimer;
extern char otherControllerDetected;
wiced_bool_t hasOnboardAltimeter = WICED_FALSE;

char printbuff[256];

void DebugWrite(const char* str)
{
    pc.printf(str);
}
void resetTimer(struct sHeatVars *s)
{
    s->resettick = 1;
    //TODO: This.
}
void resetTimerAsync(struct sHeatVars *s)
{
    s->resettick = 1;
    //TODO: This.
}
void one_second_tick()
{
    int i;
    lifetimer++; // used for wifi reset test.
    //wiced_rtos_lock_mutex( &xively_data.mutex );

    for (i = 0; i < HEATERSTATECOUNT; i++) {
        if (heaterState[i].heattime > 0 && heaterState[i].heattime < 59995) { // count down the heat timer
            // tick,tick...
            heaterState[i].heattime--;
        }
        if (heaterState[i].heatresettime > 0) {
            heaterState[i].heatresettime--;
        }
        if (heaterState[i].preheattime > 0) {
            heaterState[i].preheattime--;
        }
        if (heaterState[i].heaterDetected > 0) {
            heaterState[i].heaterDetected--;
        }
    }

    if (idletimer > 0) {
        idletimer--;
    }
    if (otherControllerDetected > 0) {
        otherControllerDetected--;
    }
    secondFlag = 1;

}

void quarter_second_tick()
{
    int i;
    for (i = 0; i < HEATERSTATECOUNT; i++) {
        heaterState[i].tickcount += 250;
        if (heaterState[i].resettick == 1) {
            heaterState[i].tickcount = 0;
            heaterState[i].resettick = 0;
        }
    }
}
void hundredms_tick()
{
    led1 = 0;// off
}

int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    pc.baud(115200);

    //Enable Pullup
    click.mode(PullUp);


    pc.printf("\n\nRIXEN Simulator v1.1 \r\n");
    led1 = 1;

    wait(1);
    led1 = 0;
    spl_i2c = new I2C(SDA, SCL);
    //canspeed = CAN500;
//    ecu.dtc = false;
//   ecu.active_fault = false;

//   sim.canspeed(CANSPEED_500);

    wait(0.2);
    led1 = 1;

    //timer.attach(&attime, 1);
    quartersecond_timed_event.attach(&quarter_second_tick, 0.250);
    hundredms_timed_event.attach(&hundredms_tick, 0.1);
    onesecond_timed_event.attach(&one_second_tick, 1.0);


    initHeaterState(&heaterState[0]);

    heaterState[0].bustype = HEATERTYPECAN;
    heaterState[0].heaternum = 1;


    InitCAN();

    double presComp;
    while(1) { // Main CAN loop

        for (int i = 0; i < HEATERSTATECOUNT; i++) {
            //            wiced_update_system_monitor(&main_thread_monitor, 10 * 1000);
            doHeatTaskCAN(&heaterState[i]);
            //            wiced_update_system_monitor(&main_thread_monitor, 10 * 1000);
            doHeatLogicTask(&heaterState[i]);
            if (i < HEATERSTATECOUNT) {
                wait_ms(50);
            } else {
                //wiced_rtos_delay_milliseconds(50);
            }
        }
        if (!click) {
            if (heaterState[0].heatOn == HEATCALLOFF) {
                set_heat_con(&heaterState[0], HEATCALLINIT);
            }
        } else {
            if (heaterState[0].heatOn != HEATCALLOFF) {
                set_heat_con(&heaterState[0], HEATCALLOFF);
            }
        }
        
        if (secondFlag > 0) {
            secondFlag = 0;

            DebugWrite("About to clean I2C\r\n");
            cleanI2CLines(spl_i2c, SDA, SCL);

            DebugWrite("Done clean I2C, get pressure\r\n");

            hasOnboardAltimeter = getPressure(&presComp);
            if (hasOnboardAltimeter) {
                int hpa = presComp / 100; // convert to HPA
                sprintf(printbuff, "Pressure %0.5lf vs %d\r\n", presComp, hpa);
                DebugWrite(printbuff);

                //sprintf(printbuff, "Pressure is %.1f (%d)\r\n", presComp, hpa);
                //DebugWrite(printbuff);
                if (hpa < 600) {
                    hpa = 680;
                }
                if (hpa > 1105) {
                    hpa = 680;
                }
                heaterState[0].rawAltitude = presComp;
                heaterState[0].internalAltitude = hpa;
            } else {
                DebugWrite("No altimeter\r\n");
            }
            if (heaterState[0].initTimer > 0) {
                heaterState[0].initTimer--;
            }
//            DebugWrite("Doing re-init of I2c\r\n");

            // check I2C
            //          DeInit_SC16IS740();
            //          DeInit_SPL0601();
            //          cleanI2CLines();
            //          Init_SC16IS740(2);
            //          Init_SPL0601();
        }
    }
}
