#include "mbed.h"
#include "epd1in54.h"
#include "imagedata.h"

#include "mRotaryEncoder.h"

#include "menu.h"

#define HEATER_OFF 0
#define HEATER_ON  1

//#include "m41t62_rtc.h"
// Control
//PinName rst;
//PinName dc;
//PinName busy;
// SPI communication
//PinName mosi;
//PinName miso;
//PinName sclk;
//PinName cs;

PinName mosi = PA_12; //D2 p5;
PinName miso = PA_11; //D10 p6;
PinName sclk = PA_1;  //A0 p7;
PinName cs =   PB_0;  //D3 p8;
PinName rst =  PB_7;  //D4 p9;
PinName dc =   PB_6;  //D5 p10;
PinName busy = PB_1;  //D6 p11;
    
Epd epd = Epd(mosi, miso, sclk, cs, dc, rst, busy);   
 
//RPG rpg1(PA_3,PA_4,PA_7); //Set up RPG 
mRotaryEncoder enc(PA_3,PA_4,PA_7,PullUp);  
 
DigitalOut myled(LED1);

//DigitalIn B_UP(PB_13);
//DigitalIn B_OK(PB_14);
//DigitalIn B_DOWN(PB_15);
//DigitalIn B_ENTER(PA_7, PullUp);

struct sDays menu_days[7];

 
unsigned char frame_black[EPD_HEIGHT*EPD_WIDTH/8];

int menu_ptr=0;  // which component are we changing?
int menu_sel=0;  // which component are we changing?

// Library calls here when you go clockwise
void cw()
{
// modify the menu pointer   
   menu_ptr += 1;
   if ( menu_ptr > MENU_MAX ) menu_ptr = MENU_MIN;
   //setleds();
}

// Library calls here when you go anticlockwise
void ccw()
{
// modify the menu pointer   
   menu_ptr -= 1;
   if ( menu_ptr < MENU_MIN ) menu_ptr = MENU_MAX;
   //setleds();
}

// Library calls here when you push in on the encoder shaft
void btn()
{
    // change selected component (0, 1, 2)
    //if (++sel>2) sel=0;
    menu_sel = true;
}



void draw_window( char *buf, int x, int y, int width, int height, int rot, int colored ); 
//void draw_menu_window( int mptr, int start, int colored );
void draw_menu_window( int mptr, int start, int runtime, enum cal_selected, int colored );
 
int main() 
{
    /*********************
    mosi = PA_12; //D2 p5;
    miso = PA_11; //D10 p6;
    sclk = PA_1;  //A0 p7;
    cs =   PB_0;  //D3 p8;
    rst =  PB_7;  //D4 p9;
    dc =   PB_6;  //D5 p10;
    busy = PB_1;  //D6 p11;
    ***********************/
    
    // Set up encoder callbacks
    enc.attachROTCW(cw);
    enc.attachROTCCW(ccw);
    enc.attachSW(btn);
    
    int heater_status = HEATER_OFF;
    int x_ptr = MENU_MIN;
    
    memset(frame_black, 0xFF, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);
 
    //Epd epd = Epd(mosi, miso, sclk, cs, dc, rst, busy);
    if (epd.Init(lut_full_update) != 0){
        return -1;
    }
 
    // clear the frame to white
   epd.SetFrameMemory(frame_black, 0, 0, epd.width, epd.height);
   epd.DisplayFrame();
   epd.SetFrameMemory(frame_black, 0, 0, epd.width, epd.height);
   epd.DisplayFrame();
 
 
    
    /* Display the frame_buffer */
    //epd.SetFrameMemory(frame_black, 0, 0, epd.width, epd.height);
    //epd.DisplayFrame();
    
    wait(2.0);
    
    if (epd.Init(lut_partial_update) != 0) 
    {
      //Serial.print("e-Paper init failed");
      return -1;
    }
    
    //epd.Sleep();
    
   // load frame onto both pages of display memory
   //epd.SetFrameMemory(IMAGE_DATA, 0, 0, epd.width, epd.height);
   //epd.DisplayFrame();
   //epd.SetFrameMemory(IMAGE_DATA, 0, 0, epd.width, epd.height);
   //epd.DisplayFrame();
   
    // load rom RHC1 frame onto both pages of display memory
   epd.SetFrameMemory(IMAGE_RHC4, 0, 0, epd.width, epd.height);
   epd.DisplayFrame();
   epd.SetFrameMemory(IMAGE_RHC4, 0, 0, epd.width, epd.height);
   epd.DisplayFrame();
   
    for ( x_ptr = MENU_MIN; x_ptr <= MENU_MAX; x_ptr++ )
    {
        if ( x_ptr == 0 || x_ptr == 6 )
            menu_days[x_ptr].start_hour = START_HOUR_OFF;
        else
            menu_days[x_ptr].start_hour = START_HOUR_DEFAULT;
            
        menu_days[x_ptr].runtime = RUN_TIME_DEFAULT;
        menu_days[x_ptr].selected = NotSel;
        draw_menu_window( x_ptr, menu_days[x_ptr].start_hour, menu_days[x_ptr].runtime, menu_days[x_ptr].selected, COLORED );
    }
    epd.DisplayFrame();
   
   //epd.Sleep();
   
    //memset(frame_black, 0xEE, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);
    
    char txtbuf[16];
    bool button_pressed = false;  
    
    set_time(1494267665); // Set RTC time to 8 May 2017 18:21:05 UTC
    
    int selected = 0;
    
    while(1) 
    {
        myled = 1;
        wait(0.1);
        myled = 0;
        //wait(0.5);
        //------try to update a time stamp window-------
        time_t seconds = time(NULL);
        char buffer[16];
        //strftime(buffer, 16, "%I:%M:%S", localtime(&seconds));
        strftime(buffer, 16, "%I:%M:%S", localtime(&seconds));
        
        //dirt = rpg1.dir(); //Get Dir
        //pulses = pulses + dirt; //Add Dir to count
        //if (rpg1.pb())
        //{
        //    pulses = 5555;  //Reset count if PB pressed
        //}
        //printf("count: %i  \r", pulses); //Print out Count
        //sprintf(buffer,"%i",pulses);
        //draw_window( buffer, 80, 72, 32, 126, ROTATE_270, COLORED );
        
        // draw heater status --- now in image
        //sprintf( txtbuf, "%s", "Status" );
        //draw_window( txtbuf, 70, 90, 32, 108, ROTATE_270, COLORED );
        for ( x_ptr = MENU_MIN; x_ptr <= MENU_MAX; x_ptr++ )
        {
            //if ( menu_ptr == selected )
            //    draw_menu_window( menu_ptr, menu_days[menu_ptr].start_hour, menu_days[menu_ptr].runtime, menu_days[menu_ptr].selected, UNCOLORED );
            //else
            //draw_menu_window( menu_ptr, menu_days[menu_ptr].start_hour, menu_days[menu_ptr].runtime, menu_days[menu_ptr].selected, COLORED );
            draw_menu_window( x_ptr, menu_days[x_ptr].start_hour, menu_days[x_ptr].runtime, menu_days[x_ptr].selected, COLORED );
        }
        // cycle through the menus
        if ( menu_ptr != selected )
        {
            menu_days[selected].selected = NotSel;
            //selected++;
            //if ( selected > MENU_MAX ) selected = MENU_MIN;
            selected = menu_ptr;
            menu_days[selected].selected = DoW;
        }
        
        if( menu_sel == true ) //&& button_pressed == false) //B_ENTER == 0 )
        {
            if ( button_pressed == false )
            {
                if ( heater_status == HEATER_OFF ) heater_status = HEATER_ON;
                else heater_status = HEATER_OFF;
                button_pressed = true;
                set_time(0);
                time_t seconds = time(NULL);
                strftime(buffer, 16, "%I:%M:%S", localtime(&seconds));
            }
            if ( heater_status == HEATER_ON )
            {
                sprintf( txtbuf, "%s", " ON " );
            }
            else
            {
                sprintf( txtbuf, "%s", " OFF" );
                sprintf( buffer, "%s", "--:--:--");                               
            }

            draw_window( txtbuf, 10, 10, 32, 80, ROTATE_270, UNCOLORED ); // status On Off, was at x=70
            //draw_window( buffer, 160, 22, 32, 146, ROTATE_270, UNCOLORED ); // clock window
        }
        else
        {
            if ( heater_status == HEATER_OFF )
            {
                sprintf( txtbuf, "%s", " OFF" );
                sprintf( buffer, "%s", "--:--:--");
                //draw_window( buffer, 160, 22, 32, 146, ROTATE_270, UNCOLORED ); // clock window
            }
            else
            {
                sprintf( txtbuf, "%s", " ON " );
                //draw_window( buffer, 160, 22, 32, 146, ROTATE_270, COLORED ); // clock window
            }
        
            draw_window( txtbuf, 10, 10, 32, 80, ROTATE_270, COLORED );  // status On Off, was at x=70
        }
        //if( rpg1.pb() ) //B_ENTER == 0 )
        //{
        //    draw_window( buffer, 100, 72, 32, 126, ROTATE_270, UNCOLORED );
        //}
        //else
        //{
        //    draw_window( buffer, 100, 72, 32, 126, ROTATE_270, COLORED );
        //}
        /************************************************************************
        epd.SetWidth(32);
        epd.SetHeight(126);
        epd.SetRotate(ROTATE_270);
        //memset(frame_black, 0xEE, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);
        //epd.SetFrameMemory(frame_black, 80, 72, epd.GetWidth(), epd.GetHeight());
        
        epd.Clear(frame_black, UNCOLORED);
        epd.DrawStringAt(frame_black, 4, 4, buffer, &Font24, COLORED); 
        epd.DrawRectangle(frame_black, 2, 2, 120, 30, COLORED);      
        
        epd.SetFrameMemory(frame_black, 80, 72, epd.GetWidth(), epd.GetHeight());
        *************************************************************************/
        epd.DisplayFrame();

        //if( rpg1.pb() == false ) //B_ENTER == 1 )
        if ( menu_sel == true )
        {
            button_pressed = false; 
            menu_sel = false;           
        }
    }
}


void draw_window( char *buf, int x, int y, int width, int height, int rot, int colored )
{ 
        int uncolored = UNCOLORED;  
        epd.SetWidth(width);
        epd.SetHeight(height);
        epd.SetRotate(rot);
        if ( colored == UNCOLORED ){ uncolored = COLORED; }
        epd.Clear(frame_black, uncolored);
        epd.DrawStringAt(frame_black, 4, 4, buf, &Font24, colored);
        //epd.DrawRectangle(frame_black, 2, 2, 120, 30, COLORED);
        epd.DrawRectangle(frame_black, 2, 2, height - 2, width - 2, colored);
        epd.SetFrameMemory(frame_black, x, y, width, height);   // copies buffer into screen frame memory    
}

char  dow[][5] = {"Sun ", "Mon ", "Tue ", "Wed ", "Thur", "Fri ", "Sat " };


void draw_menu_window( int mptr, int start, int runtime, enum cal_selected sel, int colored )
{ 
        int uncolored = UNCOLORED; 
        int x,y;
        char txtbuf[32];
        //int hours = 0;
        //int width, height;
        //x =  menu_days[mptr].x;
        //y =  menu_days[mptr].y;
        x = mptr * SMALL_MENU_WINDOW_WIDTH + SMALL_MENU_WINDOW_X_OFFSET;
        //y = mptr * SMALL_MENU_WINDOW_HEIGHT + SMALL_MENU_WINDOW_Y_OFFSET;
        y = SMALL_MENU_WINDOW_Y_OFFSET;

        epd.SetWidth(SMALL_MENU_WINDOW_WIDTH);
        epd.SetHeight(SMALL_MENU_WINDOW_HEIGHT);
        epd.SetRotate(ROTATE_270);
        if ( runtime > 60 )
            runtime = runtime/60;
        
        if ( start > START_HOUR_MIN )
        {
           sprintf( txtbuf, "%s %02d:00 %2d", dow[mptr], start, runtime); 
        }
        else 
        {
            sprintf( txtbuf, "%s %s", dow[mptr], " OFF " );                
        }
        
        //if ( colored == UNCOLORED ){ uncolored = COLORED; }
        if ( sel != NotSel ) { uncolored = COLORED; colored = UNCOLORED;}
        epd.Clear(frame_black, uncolored);
        epd.DrawStringAt(frame_black, 4, 4, txtbuf, &Font16, colored);
        //epd.DrawRectangle(frame_black, 2, 2, 120, 30, COLORED);
        //epd.DrawRectangle(frame_black, 2, 2, height - 2, width - 2, colored);
        epd.SetFrameMemory(frame_black, x, y, SMALL_MENU_WINDOW_WIDTH, SMALL_MENU_WINDOW_HEIGHT);   // copies buffer into screen frame memory    
}