#include "mbed.h"

#include "NeoMatrix.h"

//#include "WS2812.h"
//#include "PixelArray.h"

#define WS2812_BUF 70

#define Color(r, g, b)  ((r&0xFF)<<16 | (g&0xFF) << 8 | (b&0xFF))   // pack colors

#define Red     (Color(255,0,0))
#define Green   (Color(0,255,0))
#define Blue    (Color(0,0,255))


// for KL25Z
//DigitalOut CPU_Mon(PTD5);  // to measure time in output loop
// for LPC1768
//DigitalOut CPU_Mon(p21);  // to measure time in output loop
// for STM32F103 Nucleo
DigitalOut CPU_Mon(PB_6);  // to measure time in output loop

DigitalOut myled(LED1);
//DigitalOut myled2(LED2);
//DigitalOut myled3(LED3);

//PixelArray px(WS2812_BUF);
//NeoArr = px(1);

// See the program page for information on the timing numbers
// The given numbers are for the K64F: 0, 5, 5, 0
// K64F, KL46Z: 0, 5, 5, 0
//NeoArr array(PTD2, 1, 0, 5, 5, 0);
// LPC1768: 5, 10, 10, 15
//NeoArr array(p18, 1, 5, 10, 10, 15);
// STM32F103 Nucleo: 0, 5, 5, 0
NeoArr array(PC_7, 1, 0, 5, 5, 0);

Ticker timer;
char second_tick; 

// -- sets a flag every time the 5 second timer fires
void attime() 
{
    second_tick = true;
    //HazLed = 1; // turn Haz Led off
    //NmeaPrint = true;
}

//const unsigned char smile_img[8] = {0x1E,0x21,0xD2,0xC0,0xD2,0xCC,0x21,0x1E};   //   smiley
void scroll_str(char *buff, int i)
{
    //int start_px, end_px;
    //start_px = n;
    //end_px = n * -6;

    array.clear();
    array.drawChar(0,i,0,buff[0], 128,128,128);
    array.drawChar(0,i+6,0,buff[1], 128,128,128);
    array.drawChar(0,i+12,0,buff[2], 128,128,128);
    if ( buff[3] == '&' )
        array.drawChar(0,i+18,0,buff[3], 255,255,0);
    else
        array.drawChar(0,i+18,0,buff[3], 255,0,0);
        //CPU_Mon = 1;
    array.write();

}

int main()
{
    char led_str[6];
    char c;
    int distance = 900;
    float bright = 0.2; // 20% is bright enough for most indoor use and should run without need for external power

    array.setBrightness(bright);    // set brightness to default 0.2
    array.clear();
    myled = 1;
    wait_ms(500);
    myled = 0;
    wait_ms(500);
    myled = 1;
    second_tick = false; 
    timer.attach(&attime, 1); 
    c = '0';  
    
    while (true)
    {
        while ( 1 )
        {  
            /******************************
            array.clear();
            array.write();
            wait_ms(2000);
            array.drawChar(0,0,0,'V', 1,128,1);
            array.drawChar(0,5,0,'C', 1,128,1);
            array.drawChar(0,10,0,'P', 1,128,1);
            array.write();  
            wait_ms(2000);
            array.clear();
            array.drawChar(0,0,0,'2', 128,128,1);
            array.drawChar(0,5,0,'8', 128,128,1);
            array.drawChar(0,10,0,'7', 128,128,1);
            array.write();  
            wait_ms(2000); 
            ******************************/ 
            /**********************************  
            for (char i='A'; i<'Z'; i+=3 )
            {
                array.clear();
                array.drawChar(0,0,0,i, 1,128,1);
                array.drawChar(0,5,0,i+1, 128,1,1);
                array.drawChar(0,10,0,i+2, 1,1,128);
                array.write();  
                wait_ms(2000);   
            } 
            *************************************/ 
            array.clear();
            array.drawChar(0,0,0,'?', 128,0,0);
            array.drawChar(0,5,0,'6', 128,128,128);
            array.drawChar(0,9,0,':', 128,1,1);
            array.write();  
            wait_ms(2000);
            
            array.clear();
            array.drawChar(0,0,0,'?', 128,0,0);
            array.drawChar(0,5,0,'1', 128,128,128);
            array.drawChar(0,9,0,';', 128,1,1);
            array.write();  
            wait_ms(2000); 
            
            array.clear();
            array.drawChar(0,0,0,'?', 128,0,0);
            array.drawChar(0,5,0,'8', 128,128,128);
            array.drawChar(0,9,0,'^', 128,1,1);
            array.write();  
            wait_ms(2000);    
            
            /****************************************************
            array.fillScreen(0,128, 0, 0);
            array.write();
            wait_ms(2000);
            
            array.fillScreen(0,0, 128, 0);
            array.write();
            wait_ms(2000);
            
            array.fillScreen(0,0, 0, 128);
            array.write();
            wait_ms(2000);
            
            array.clear();
            for(int i=0; i<14; i++)
            {
                for(int n=0; n<5; n++)
                {
                    array.setPixel(0, i, n, 128, 0, 128);
                    array.write();
                    wait_ms(200);
                }
            }
            
            wait_ms(2000);
            *****************************************/
            
            //for ( i =
            /*****************************************         
            //sprintf( led_str, "VCP", distance, c); 
            for(int i=7;i>=-16;i--)
            {
                array.clear();
                array.drawChar(0,i,0,'V', 128,128,128);
                array.drawChar(0,i+6,0,'C', 128,128,128);
                array.drawChar(0,i+12,0,'P', 128,128,128);
                array.write();
                //scroll_str( led_str, i );
                wait_ms(75);
            }  
            wait_ms(100); 
            for(int i=7;i>=-16;i--)
            {
                array.clear();
                array.drawChar(0,i,0,'2', 128,128,128);
                array.drawChar(0,i+6,0,'7', 128,128,128);
                array.drawChar(0,i+12,0,'1', 128,128,128);
                array.write();
                //scroll_str( led_str, i );
                wait_ms(75);
            } 
            wait_ms(100);
            array.clear();
            array.showImageRGB(0, 1, 255, 255, 0);
            array.write();
            wait_ms(400);
            *******************************************/
            //wait_ms(4000);
        }             
            //sprintf( led_str, "%3d%c", distance, c);    
        /*************************************************
        while ( 1 )
        {
          if ( distance > 500 ) c = '$';
          else c = '&';
          sprintf( led_str, "%3d%c", distance, c);
          for(int i=7;i>=-24;i--)
          {
                //myled = 1;
                //CPU_Mon = 1;
                //array.clear();
                //array.drawChar(0,i,0,'2', 128,128,128);
                //array.drawChar(0,i+6,0,'4', 128,128,128);
                //array.drawChar(0,i+12,0,'8', 128,128,128);
                //array.drawChar(0,i+18,0,'$', 255,0,0);
                //CPU_Mon = 1;
                //array.write();
                //myled = 0;
                //CPU_Mon = 0;
                scroll_str( led_str, i );
                wait_ms(75);
          }  
          //wait_ms(500);
          //array.clear();
          //array.showImageRGB(0, 1, 255, 255, 0);
          //array.drawChar(0,i+18,0,'$', 255,0,0);
          //array.write();
          //wait_ms(500);
          distance -= 108;
          if ( distance < 100 ) distance = 900;
        } 
        
        if ( second_tick == true )
        {
            second_tick = false;            
            array.clear();
            array.drawChar(0,0,1,c, 128,128,128);
            if ( c > '7' )
                array.drawChar(0,4,0,'^', 255,0,0);
            else if ( c > '4' )
                array.drawChar(0,4,0,':', 255,0,0);
            else if ( c == '3' )
                array.drawChar(0,5,1,'>', 255,0,0);
            else if ( c == '2' )
                array.drawChar(0,5,1,'<', 255,0,0);                
            else
                array.drawChar(0,4,0,';', 255,0,0);
            array.write();
            c++;
            if ( c > '9' ) c = '0';
        } 
        *******************************************/              
    }
}
