#include "mbed.h"
#include "TextLCD.h"
#include "mRotaryEncoder.h"
 
DigitalOut fan_enable(PA_8); // high to enable fan, low to turn off
PwmOut fan_pwm(PB_15);    //D9 D13);
// I2C Communication
I2C i2c_lcd(PB_7,PB_6); // SDA, SCL
 
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type 

// Here's the encoder object
//mRotaryEncoder enc(D7,D8, D2,PullNone);
//RPG rpg1(PA_3,PA_4,PA_7); //Set up RPG   
//mRotaryEncoder enc(PA_3,PA_4,PA_7,PullUp);
mRotaryEncoder enc(PB_12,PB_13,PB_14,PullUp);

float fan_speed = 0.00;
float fan_speed_old = 0.00;
int fan_pwr=0;  //
char buffer[20];
 

// LCD print helper
void lcd_printS(int line, int col, char text[])
{
    lcd.locate(col, line);       //locate(int column, int row);
    lcd.printf(text);
    //for (i=0;i<strlen(text);i++) 
    //    printC(text[i]);
}

// Helper function to set the PWM values
void setfanspeed()
{
    //if (fan_pwr>0) fan_pwm.write(fan_speed);
    fan_pwm.write(fan_speed);
    //fan_pwm.write(1.00 - fan_speed);
}

// Library calls here when you go clockwise
void cw()
{
// modify the selected RGB component    
    if (fan_pwr>0)
    {
        fan_speed +=0.010;
        if (fan_speed>0.95) fan_speed=0.950;
    }
    setfanspeed();
}

// Library calls here when you go anticlockwise
void ccw()
{
// modify the selected RGB component    
   if (fan_pwr>0) 
   {
        fan_speed -=0.010;
        if (fan_speed<0.05) fan_speed=0.050;
   }
   setfanspeed();
}

// Library calls here when you push in on the encoder shaft
void btn()
{
    // change selected component (0, 1, 2)
    if (++fan_pwr>1)
    {
         fan_enable = 0;     // turn fan OFF
         fan_pwr=0;
         fan_speed_old = fan_speed;
         fan_speed = 0.00;         
    }
    else
    {
       fan_enable = 1;     // turn fan ON
       fan_speed = fan_speed_old; 
    }
    setfanspeed();
}



int main() 
{
    fan_enable = 0;     // turn fan off
    //fan_pwm.period(0.01); // setup PWM in seconds. 0.01 == 100hz
    //fan_pwm.period_ms(100); // setup PWM in milli seconds. 1 == 1 khz
    // Note: the PWM using the 555 supplied by RIXENS runs around 200khz
    // - running the pwm at 100khz looses resolution at the top and bottom.
    // - running the pwm at 10khz has much more accuracy and resolution.
    // - running the pwm at 20khz has same accuracy and resolution as 10khz.
    fan_pwm.period_us(100); // setup PWM in micro seconds. 100 == 10khz, 50 == 20khz,10 == 100khz, 5 == 200khz,
    
    setfanspeed();
    // Set up encoder callbacks
    enc.attachROTCW(cw);
    enc.attachROTCCW(ccw);
    enc.attachSW(btn);   
       
    lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
    lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn
    lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
    //lcd.printf("Testing I2C LCD");
    //lcd.locate(0, 1);       //locate(int column, int row);
    //lcd.printf("does it work");
    //lcd.setBacklight(TextLCD::LightOn);//LightOff, LightOn
       
    lcd.cls();
    lcd_printS(0,0,"Fan Setting:");
    lcd_printS(1,0,"Fan Speed: ");
 
    while (true)   // nothing else to do but wait
    {  
        wait(0.25);    
        if (fan_pwr>0) lcd_printS(0,12," ON ");
        else lcd_printS(0,12," OFF");
        sprintf(buffer,"%3d", (int)(fan_speed * 100));
        lcd_printS(1,12,buffer);  
        //LCD.printS(1, 0, buffer);   
    }
}