/* main.cpp in HelloLWIPBP3595Interface */
/* Copyright (C) 2016 Grape Systems, Inc. */
/* The base file is main.cpp in HelloLWIPInterface. */

/* main.cpp in HelloLWIPInterface */
/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This is a NetworkSocketAPI example for LWIPBP3595Interface_STA library. */
/* LWIPBP3595Interface_STA library only works with GR-PEACH. */
/* The base example is HelloLWIPInterface. */

/*
Warning!
  When exporting and using it, increase the following stack size.
  
  [LWIPInterface/lwip/lwipopts.h]-------------
  #define TCPIP_THREAD_STACKSIZE      1024
  ->
  #define TCPIP_THREAD_STACKSIZE      2048
  --------------------------------------------
*/

/*
This program works with the following library.
  mbed-rtos : revision 115
*/

#include "mbed.h"
#include "LWIPBP3595Interface.h"
#include "TCPSocket.h"

LWIPBP3595Interface wifi;

DigitalOut led(LED_GREEN);
void blink()
{
    led = !led;
}

int main()
{
    Ticker blinky;
    blinky.attach(blink, 0.4f);

    printf("NetworkSocketAPI Example\r\n");

    wifi.connect("ssid", "password", NSAPI_SECURITY_WPA2);
    const char *ip = wifi.get_ip_address();
    const char *mac = wifi.get_mac_address();
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
    printf("MAC address is: %s\r\n", mac ? mac : "No MAC");
    
    SocketAddress addr(&wifi, "mbed.org");
    printf("mbed.org resolved to: %s\r\n", addr.get_ip_address());

    TCPSocket socket(&wifi);
    socket.connect("4.ifcfg.me", 23);

    char buffer[64];
    int count = socket.recv(buffer, sizeof buffer);
    printf("public IP address is: %.15s\r\n", &buffer[15]);
    
    socket.close();
    wifi.disconnect();

    printf("Done\r\n");
}
