/* This is a sample application program for GR-PEACH_WlanBP3595STA library. */
/* GR-PEACH_WlanBP3595STA library only works with GR-PEACH. */
/* This sample works as TCP socket sever, and this program sends a message */
/* when a connection is accepted. */

/*
Warning!
  When exporting and using it, increase the following stack size.
  
  [EthernetInterface/lwip/lwipopts.h]---------
  #define TCPIP_THREAD_STACKSIZE      1024
  ->
  #define TCPIP_THREAD_STACKSIZE      2048
  --------------------------------------------
*/

/*
This works with the following library.
  mbed-rtos : revision 115
*/

#include "mbed.h"
#include "rtos.h"
#include "GR_PEACH_WlanBP3595.h"

/* Please change the following macro definition to your setting. */
#define WLAN_SSID               ("SSIDofYourAP")                // SSID
#define WLAN_PSK                ("PSKofYourAP")                 // PSK(Pre-Shared Key)
#define SERVER_IP               ("192.168.1.200")               // Server IP address
#define SERVER_PORT             (50000)                         // TCP server socket port number
#define SUBNET_MASK             ("255.255.255.0")               // Subnet mask
#define DEFAULT_GATEWAY         ("192.168.1.1")                 // Default gateway
#define SEND_MESSAGE            ("Hello, world!\r\n")           // Send-message

static void _wlan_inf_callback(uint8_t ucType, uint16_t usWid, uint16_t usSize, uint8_t *pucData);

DigitalOut  red_led(LED1);              // On: error
DigitalOut  green_led(LED2);            // On: WLAN has been connected

/** Main function
 *
 */
int main() {
    GR_PEACH_WlanBP3595 wlan;
    TCPSocketServer     server;
    TCPSocketConnection connection;
    int                 ret;

    wlan.setWlanCbFunction(_wlan_inf_callback);

    /* Initialize GR_PEACH_WlanBP3595 */
    ret = wlan.init(SERVER_IP, SUBNET_MASK, DEFAULT_GATEWAY);
    if (ret != 0) {
        /* error */
        red_led = 1;
        while (1) { Thread::wait(1000); }
    }

    /* Connect(GR_PEACH_WlanBP3595) */
    ret = wlan.connect(WLAN_SSID, WLAN_PSK);
    if (ret != 0) {
        /* error */
        red_led = 1;
        while (1) { Thread::wait(1000); }
    }

    /* Bind and listen */
    server.bind(SERVER_PORT);
    server.listen();

    /* Loop */
    while (1) {
        /* Accept */
        server.accept(connection);
        printf("Connection from: %s\n", connection.get_address());

        /* Send a message */
        connection.send_all((char *)SEND_MESSAGE, sizeof(SEND_MESSAGE)-1);

        /* Close */
        connection.close();
    }
}

/** WLAN Information callback function
 *
 */
static void _wlan_inf_callback(uint8_t ucType, uint16_t usWid, uint16_t usSize, uint8_t *pucData)
{
    if (ucType == 'I') {
        if (usWid == 0x0005) {    // WID_STATUS
            if (pucData[0] == 0x01) {     // CONNECTED
                green_led = 1;
            } else {
                green_led = 0;
            }
        }
    }
}
