/*
Simple Routine for Nucleo Board for ROCO104 Buggy Motor Control and Microswitches
Heavy edit from previous ROCO103PP code
Motor Class can now be instansiated with all four pins needed to control the H Bridge
with a member functions as follows

Motor::Speed(float A, Float B) range -0.1 to +1.0 to give full reverse to full forward for A/B motors
Motor::Stop()       STOP
Motor::Fwd(float)   Forward but floating point number (range 0.0 to 1.0)
Motor::Rev(float)   Reverse but floating point number (range 0.0 to 1.0)

Plymouth University
M.Simpson 31st October 2016
Edited 03/02/2017
Edited 06/12/2018
*/
#include "mbed.h"
#include "motor.h"
#include "tunes.h"

#define TIME_PERIOD 2             //Constant compiler Values here 2 equates to 2ms or 500Hz base Frequency
#define DUTY 0.9                  //DUTY of 1.0=100%, 0.4=40% etc.,

DigitalIn microswitch1(D4);       //Instance of the DigitalIn class called 'microswitch1'
DigitalIn microswitch2(D3);       //Instance of the DigitalIn class called 'microswitch2'

Motor Wheel(D13,D11,D9,D10);      //Instance of the Motor Class called 'Wheel' see motor.h and motor.cpp

DigitalIn myButton(USER_BUTTON);  //USER_BUTTON is the Blue Button on the NUCLEO Board

DigitalOut led(LED3);             //LED1 is the Green LED on the NUCLEO board
//N.B. The RED LED is the POWER Indicator
//and the Multicoloured LED indicates status of the ST-LINK Programming cycle

Serial pc(USBTX,USBRX);           //Instance of the Serial class to enable much faster BAUD rates then standard 9600 i.e. 115200
//This is Pseudo RS232 over USB the NUCLEO will appear as a COMx Port see device Manager on PC used
//Use PuTTY to monitor check COMx and BAUD rate (115200)


//Variable 'duty' for programmer to use to vary speed as required set here to #define compiler constant see above
float duty=DUTY;
//

void fwdBack(){
     int fBOn = 1;
     while(fBOn == 1){
        Wheel.Speed(0.8,0.8); 
        if (microswitch1 == 1){
            wait(0.2);
            Wheel.Speed(-0.8,-0.8);
            fBOn = 0;
            }
        }
    }

void turn(){
    int tOn = 1;
    while (tOn == 1){
    
        if (microswitch2 == 1){
            wait(0.2);
            Wheel.Speed(0.5,0.5);
            wait(0.5);
            Wheel.Speed(0.0,0.8);
            wait(1);
            Wheel.Speed(0.8,0.8);
            wait(2);
            Wheel.Speed(0.8,0.0);
            wait(0.5);
            tOn = 0;
            }
        }
    }
    
int main ()
{
    pc.baud(9600);               //BAUD Rate to 9600
    pc.printf("ROCO104 Demonstration Robot Buggy Plymouth University 2018/19\n\r");

    Wheel.Period_in_ms(TIME_PERIOD);//Set frequency of the PWMs

    //
    //--------------------------- your strategy goes between the two dashed lines ---------------------------------------------
    //
    Wheel.Stop();

    //close_encounter(1);     //tune to play Announce start!
    //twinkle(1);           //see tunes.h for alternatives or make your own!
    //jingle_bells(1);
    megolavania(1);
    while(myButton==0) {
        //Wait here for USER Button (Blue) on Nucleo Board (goes to zero when pressed)
        led=0;              //and flash green LED whilst waiting
        wait(0.1);
        led=1;
        wait(0.1);
        //Test Microswitches with two different tones see tunes.cpp tunes.h or flash (led1 and led2) onboard LEDs

    }

    //Repeat the following forever NB always true!

// YOUR LINES OF CODE for your stratagy go between HERE! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    Wheel.Period_in_ms(2);//Set frequency of the PWMs 500Hz
    
    int on = 1;
    
    while(on == 1){
        fwdBack();
        turn();
        }
        
    
    
    
    
    
    
    
    
   /* while (true) {
        
        while(microswitch1 == 0);
        {
            Wheel.Speed(0.8,0.8);
        }

        Wheel.Stop();

        while(microswitch2 == 0)
        {
            Wheel.Speed(-0.8,-0.8);
        }

        //turn right
        Wheel.Speed(0.8,0.0);
        wait(0.5);

        //forward
        Wheel.Speed(0.8,0.8);
        wait(0.5);

        //turn left
        Wheel.Speed(0.0,0.8);
        wait(0.5);
        


    }
    
*/
}

// and HERE! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// go back to start of while loop
//end of int main()



/*
//Consider these lines of code to Accelerate the motors
      for (float i=0.5f; i<=1.0f; i+=0.01f) //Accelerate  from 50% to 100%
      {
        Wheel.Speed(i,i);
        wait(0.1f);
      }
*/
