/*
Simple Routine for Nucleo Board for ROCO104 Buggy Motor Control and Microswitches
Heavy edit from previous ROCO103PP code
Motor Class can now be instansiated with all four pins needed to control the H Bridge
with a member functions as follows

Motor::Speed(float A, Float B) range -0.1 to +1.0 to give full reverse to full forward for A/B motors
Motor::Stop()       STOP
Motor::Fwd(float)   Forward but floating point number (range 0.0 to 1.0)
Motor::Rev(float)   Reverse but floating point number (range 0.0 to 1.0)

Plymouth University
M.Simpson 31st October 2016
Edited 03/02/2017
Edited 06/12/2018
*/
#include "mbed.h"
#include "motor.h"
#include "tunes.h"
#include "Travel.h"
#include "board.h"

#define TIME_PERIOD 2             //Constant compiler Values here 2 equates to 2ms or 500Hz base Frequency
#define DUTY 0.9                  //DUTY of 1.0=100%, 0.4=40% etc.,



DigitalIn microswitch1(D4);       //Instance of the DigitalIn class called 'microswitch1'
DigitalIn microswitch2(D3);       //Instance of the DigitalIn class called 'microswitch2'

Motor Wheel(D13,D11,D9,D10);      //Instance of the Motor Class called 'Wheel' see motor.h and motor.cpp

DigitalIn myButton(USER_BUTTON);  //USER_BUTTON is the Blue Button on the NUCLEO Board

DigitalOut led(LED3);             //LED1 is the Green LED on the NUCLEO board
//N.B. The RED LED is the POWER Indicator
//and the Multicoloured LED indicates status of the ST-LINK Programming cycle

Serial pc(USBTX,USBRX);           //Instance of the Serial class to enable much faster BAUD rates then standard 9600 i.e. 115200
//This is Pseudo RS232 over USB the NUCLEO will appear as a COMx Port see device Manager on PC used
//Use PuTTY to monitor check COMx and BAUD rate (115200)


//Variable 'duty' for programmer to use to vary speed as required set here to #define compiler constant see above
float duty=DUTY;

  /*
// This is the fwdBack function with acceleration. 
void fwdBack() {

  for (float i = 0.5f; i <= 1; i += 0.01f) //Accelerate  from 50% to 100%
  {
    Wheel.Speed(i, i);
    wait(0.1f);
    if (microswitch1 == 1) {
      wait(0.2);
      break;
    }
  }
  if (microswitch1 == 1){
  for (float i = 0.5f; i <= 1; i -= 0.01f) //Accelerate  from 50% to 100% in reverse!
  {
    Wheel.Speed(i, i);
    wait(0.1f);
    if (microswitch2 == 1) {
      wait(0.2);
      break;
    }
  }
  if (microswitch2 == 1) {
    wait(0.2);
    Wheel.Speed(0.0, 0.0);
  }
  
  }
  
*/
/*/ //The 3rd version including james toggles and acceleration. 
void fwdBack() {
  int fBOn = 1;
  while (fBOn == 1) {
    for (float i = 0.5f; i <= 1; i += 0.01f) //Accelerate  from 50% to 100%
    {
      Wheel.Speed(i, i);
      wait(0.1f);
      if (microswitch1 == 1) {
        wait(0.2);
        break;
      }
    if (microswitch1 == 1) {
      wait(0.2);
      for (float i = 0.5f; i <= 1; i -= 0.01f) //Accelerate  from 50% to 100% in reverse!
      {
        Wheel.Speed(i, i);
        wait(0.1f);
        if (microswitch2 == 1) {
          wait(0.2);
          break;
        }
      fBOn = 0;
    }
  }
}

    */


    
int main ()
{
    pc.baud(9600);               //BAUD Rate to 9600
    pc.printf("ROCO104 Demonstration Robot Buggy Plymouth University 2018/19\n\r");

    Wheel.Period_in_ms(TIME_PERIOD);//Set frequency of the PWMs

    //
    //--------------------------- your strategy goes between the two dashed lines ---------------------------------------------
    //
    Wheel.Stop();

    megolavania(1);
    
    blueButton(); 
    
// YOUR LINES OF CODE for your stratagy go between HERE! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    Wheel.Period_in_ms(2);//Set frequency of the PWMs 500Hz
    
    int on = 1;
    
    while(on == 1){
        fwdBack();
        turn();
    }
}
    



// and HERE! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// go back to start of while loop
//end of int main()



/*
//Consider these lines of code to Accelerate the motors
      for (float i=0.5f; i<=1.0f; i+=0.01f) //Accelerate  from 50% to 100%
      {
        Wheel.Speed(i,i);
        wait(0.1f);
      }
*/
