/* final project */
#include "mbed.h"

#define Ts 0.01f    // period of timer1 (s)
#define Kp 0.053f
#define Ki 0.013f
#define Kro 0.01f
#define Kalpha 0.3f
#define Kbeta 0.0f

#define DUTY_MID 0.079f // servo
#define SERVO_PERIOD 20

#define PWM1_PERIOD 50
#define PWM2_PERIOD 50

#define WHEEL_RADIUS 0.03f
#define CAR_WIDTH 0.08f

#define PI_MAX 0.5f
#define I_MAX 0.5f

#define FORWARD 0
#define INVERSE 1

///// PinNumber /////
// servo
PwmOut servo(A0);// pin A0

// DCMotor
PwmOut pwm1(D7);
PwmOut pwm1n(D11);
PwmOut pwm2(D8);
PwmOut pwm2n(A3);

// LED 
DigitalOut led1(A4);
DigitalOut led2(A5);

// Motor1 sensor
InterruptIn HallA_1(A1);
InterruptIn HallB_1(A2);
//Motor2 sensor
InterruptIn HallA_2(D13);
InterruptIn HallB_2(D12);



///// Timer /////
Ticker timer1;

///// UART /////
Serial pc(D1, D0);
Serial bluetooth(D10, D2); // Tx Rx

///// Declaration /////
// Variable(s) for internal control //
// serovo
volatile float ang_cmd = 0;
float servo_duty = 0.079;  //0.079 +(0.084/180)*angle, initial angle:-90 at 0.079, -90<angle<90
float PIout = 0.0;

// DCMotor
float pwm1_duty = 0.5;
float pwm2_duty = 0.5;


// CN interrupt //
// hall state
int8_t stateA_1 = 0, stateB_1 = 0, stateA_2 = 0, stateB_2 = 0;  // hall state
int8_t state_1 = 0, state_1_old = 0, state_2 = 0, state_2_old = 0;   // state
 
int w1count = 0;
int w2count = 0;

float w1 = 0.0, w1_ref = 0.0; // speed
float w1_err = 0.0, w1_ierr = 0.0, PIout_1 = 0.0;
float w2 = 0.0, w2_ref = 0.0;
float w2_err = 0.0, w2_ierr = 0.0, PIout_2 = 0.0; 

// Rx
unsigned char Receive_Data[14];
int Receive_Flag = 0, Receive_Counter = 0;

// Tx
int Command_Flag = 0;

float Position_Error = 0.0;
float Theta_Error = 0.0;
float Beta_Error = 0.0;


// Function 
void timer1_interrupt(void);
void init_TIMER(void);

void init_IO(void);
void init_PWM(void);

void CN_interrupt(void);
void init_CN(void);

void init_BT(void);
void BT_interrupt(void);

int main() 
{
    init_IO();
    init_TIMER();
    init_PWM();
    init_BT();
    
    while(1) // always run
    {
        
    }
}

void init_IO(void)
{
    led1 = 0;
    led2 = 1;
}

void init_TIMER(void){
    timer1.attach_us(&timer1_interrupt, 10000.0);// 10ms interrupt period (0.1 KHz)
}

void timer1_interrupt(void)
{
    // Motor l speed calculation //
    w1 = (float)w1count * 100.0f / 12.0f * 60.0f / 29.0f;   //unit: rpm    100*10000us*60 = 1min  12cycle/revolution  speed reduction ratio:29
    w1count = 0;
    //w1_ref = (Kro*Position_Error + Kalpha*Alpha_Error)*CAR_WIDTH/WHEEL_RADIUS;
    w1_ref = (Kro*Position_Error + (Kalpha*(Beta_Error-Theta_Error) + Kbeta*Beta_Error)*CAR_WIDTH) / WHEEL_RADIUS;
    
    // PI control
    w1_err = w1_ref - w1;
    w1_ierr = w1_ierr + Ts*w1_err;
    PIout_1 = w1_err*Kp + w1_ierr*Ki;
    
    // set limitation of PI
    
    if(PIout_1 >= 0.5f) PIout_1 = 0.5f;
    else if(PIout_1 <= -0.5f) PIout_1 = -0.5f;
    pwm1.write(PIout_1 + pwm1_duty); // initial pwm = pwm1_duty
    TIM1->CCER |= 0x4; // 設定互補模式（橋式電容）
    
    // Motor 2
    w2 = (float)w2count * 100.0f / 12.0f * 60.0f / 29.0f;   //unit: rpm
    w2count = 0;
    w2_ref = (Kro*Position_Error - (Kalpha*(Beta_Error-Theta_Error) + Kbeta*Beta_Error)*CAR_WIDTH) / WHEEL_RADIUS;
    
    // PI control //
    w2_err = w2_ref - w2;
    w2_ierr = w2_ierr + Ts*w2_err;
    PIout_2 = w2_err*Kp + w2_ierr*Ki;
    
    /////////////////////////
    
    if(PIout_2 >= 0.5f) PIout_2 = 0.5f;
    else if(PIout_2 <= -0.5f) PIout_2 = -0.5f;
    pwm2.write(PIout_2 + pwm2_duty);
    TIM1->CCER |= 0x40; // 
    
    // Position //    
    if(Command_Flag == 1)
    {
        Position_Error = (Receive_Data[2]-0x30)*100 + (Receive_Data[3]-0x30)*10 + (Receive_Data[4]-0x30); // 0x30 16進位的30 ASCII的0 
        if (Receive_Data[1] == '-') Position_Error = -1*Position_Error;
        else Position_Error = Position_Error;
        
        Theta_Error = (Receive_Data[6]-0x30)*100 + (Receive_Data[7]-0x30)*10 + (Receive_Data[8]-0x30);
        if (Receive_Data[5] == '-') Theta_Error = -1*Theta_Error;
        else Theta_Error = Theta_Error;
        
        Beta_Error = (Receive_Data[10]-0x30)*100 + (Receive_Data[11]-0x30)*10 + (Receive_Data[12]-0x30);
        if (Receive_Data[9] == '-') Beta_Error = -1*Beta_Error;
        else Beta_Error = Beta_Error;
        
        
        if (Receive_Data[13] == 'j') pwm1_duty = 0.5;
        else if (Receive_Data[13] == 'k') pwm1_duty = 0.5;
        Command_Flag = 0;
    }
    ///////////////////////////
    //printf("%c\n",pc.getc());
    if (Receive_Data[13] == 'c') servo_duty = DUTY_MID +(0.092/180) * ang_cmd;
    if(servo_duty >= 0.121f) servo_duty = 0.121;
    else if(servo_duty <= 0.037f) servo_duty = DUTY_MID;  // 0.037~0.121
    servo.write(servo_duty);
}


void init_PWM(void) // DCMotor servo
{
    pwm1.period_us(PWM1_PERIOD);
    pwm1.write(0.5); // write to pwm1
    TIM1->CCER |= 0x4;
    
    pwm2.period_us(PWM2_PERIOD);
    pwm2.write(0.5);
    TIM1->CCER |= 0x40;
    
    servo.period_ms(SERVO_PERIOD);
    servo.write(servo_duty);
}

void init_BT(void)
{
    bluetooth.baud(115200);
    pc.baud(57600);
    if(bluetooth.readable()) bluetooth.attach(&BT_interrupt);
}

// Recieve 
void BT_interrupt(void)
{
    /////////Receive//////////
    static char Temp; // static 只會初始化一次 
    Temp = pc.getc();
    
    if(Receive_Flag == 1)
    {
        Receive_Counter++;
        Receive_Data[Receive_Counter] = Temp;
                
        if (Receive_Counter == 13)
        {
            //Send_Flag = 1;
            Command_Flag = 1;
            Receive_Flag = 0;
            Receive_Counter = 0;
        }         
    }
    else
    {
        if(Temp == 36 && Command_Flag == 0)     // ASCII 36 ='$'
        {
            Receive_Flag = 1;
            Receive_Counter = 0;
            Receive_Data[0] = Temp;
        }
        else
        {       
            //LATDbits.LATD2 = !LATDbits.LATD2;
            // Waiting
        }
    } 
}


void init_CN(void)
{
    HallA_1.rise(&CN_interrupt);
    HallA_1.fall(&CN_interrupt);
    HallB_1.rise(&CN_interrupt);
    HallB_1.fall(&CN_interrupt);
    
    HallA_2.rise(&CN_interrupt);
    HallA_2.fall(&CN_interrupt);
    HallB_2.rise(&CN_interrupt);
    HallB_2.fall(&CN_interrupt);
    
    stateA_1 = HallA_1.read();
    stateB_1 = HallB_1.read();
    stateA_2 = HallA_2.read();
    stateB_2 = HallB_2.read();
}
void CN_interrupt(void)   // ISR(interrupt serviecs register)
{
    //Motor 1
    stateA_1 = HallA_1.read();
    stateB_1 = HallB_1.read();
    
    ///code for state determination///
    if (stateA_1 == 0 && stateB_1 == 0) state_1 = 1;
    else if (stateA_1 == 0 && stateB_1 == 1) state_1 = 2;
    else if (stateA_1 == 1 && stateB_1 == 1) state_1 = 3;
    else if  (stateA_1 == 1 && stateB_1 == 0) state_1 = 4;
    
    state_1_old = state_1;
    
    //////////////////////////////////
    
    //Forward
    if (state_1 - state_1_old == 1 || state_1 - state_1_old  == -3)
    w1count++;
    //w1Count +1
    
    //Inverse
    else if (state_1 - state_1_old == -1 || state_1 - state_1_old  == 3)
    w1count--;
    //w1Count -1
    
    
    //Motor 2
    stateA_2 = HallA_2.read();
    stateB_2 = HallB_2.read();
    
    ///code for state determination///
    if (stateA_2 == 0 && stateB_2 == 0) state_2 = 1;
    else if (stateA_2 == 0 && stateB_2 == 1) state_2 = 2;
    else if (stateA_2 == 1 && stateB_2 == 1) state_2 = 3;
    else if  (stateA_2 == 1 && stateB_2 == 0) state_2 = 4;
    
    //////////////////////////////////
    
    //Forward
    if (state_2 - state_2_old == 1 || state_2 - state_2_old  == -3)
    w2count++;
    //w2Count +1
    //Inverse
    else if (state_2 - state_2_old == -1 || state_2 - state_2_old  == 3)
    w2count--;
    //w2Count -1
    
}
