#include "mbed.h"
#include "base.h"

volatile uint16_t count = 0;
volatile uint8_t led_toggle = 0;
volatile uint8_t led0_toggle = 0;
DigitalOut myled(USER_LED0);
DigitalOut led1(USER_LED1);
DigitalOut led2(USER_LED2);

Ticker timer_led;
Timeout timeDelay;

void ISR_blink(){
    count++;
    
    if(count == 500){
        led0_toggle = 1;
    }
    
    if(count == 1000){
        led_toggle = 1;
        count = 0;
    }
}

void timer_Init(){
    myled = 1;
    led1 = 0;
    led2 = 1;
    timer_led.attach_us(&ISR_blink , 1000);
}

void timer_set(){
    timeDelay.attach(&timer_Init , 1.0);
    myled = 0;
    led1 = 1;
    led2 = 0;
    
    count = 0;
}

int main() {
    
    timer_set();
    
    while(1) {
        //2Hz
        if(led0_toggle){
            myled = !myled;
            led0_toggle = 0;
        }
        
        //1Hz
        if(led_toggle){
            myled = !myled;
            led1 = !led1;
            led2 = !led2;
            led_toggle = 0;
        }
    }
}
