#include "mbed.h"
#include "base.h"

volatile uint16_t count = 0;
DigitalOut myled(USER_LED0);
DigitalOut led1(USER_LED1);
DigitalOut led2(USER_LED2);

Ticker timer_led;
Timeout timeDelay;

void ISR_blink(){
    count++;
}

void timer_Init(){
    myled = 1;
    led1 = 1;
    led2 = 0;
    timer_led.attach_us(&ISR_blink , 1000);
}

void timer_set(){
    timeDelay.attach(&timer_Init , 1.0);
    myled = 0;
    led1 = 0;
    led2 = 0;
    
    count = 0;
}

int main() {
    
    timer_set();
    
    while(1) {
        //2Hz
        if(count == 500){
            myled = !myled;
        }
        
        //1Hz
        if(count == 1000){
            myled = !myled;
            led1 = !led1;
            led2 = !led2;
            count = 0;
        }
    }
}
