#include "mbed.h"


float read=0;


int btcmd[4] ={0,0,0,0};

double dutyCycle=0.035; 
short Lstate[2]={1};
short Rstate[2]={1};
short Ldir=0;
short Rdir=0;
float pi=3.141592;
int counter[2]={0};
int counter2[2]={0};
float speed[2]={1};
float speed2[2]={1};
int second=0;
int btcount=0;

   float Kp[4]={3.7,3.7,1,1};
   float Ki[4]={0.65,0.65,1,1};
   float Gain[2]={0.7,0.7};
    float input[2]={0.5};
    static const float factor=0.001;
    float Error[2]={0.5},Error_Old[2]={0.5};
    float Ed,Ei[2]={0.5};
    float Output[2]={0.5};
    static const double Boundary_H=0.5;
    static const double Boundary_L=-0.5;
    bool reverse[2]={1};
    bool flag[2]={0};
    int readcount=0; 
    char temp_data[7]={0};
    bool servocheck=0;
    

/******************** I/O define ****************************/
InterruptIn Hall_Left1(A1);  //D12 D13  &  A1 A2
InterruptIn Hall_Left2(A2);

InterruptIn Hall_Right1(D12);
InterruptIn Hall_Right2(D15);
PwmOut Pwm_Left(D7);  // D7 D11
PwmOut Pwm_Right(D8); // D8 A3
PwmOut Pwm_LeftN(D11);
PwmOut Pwm_RightN(A3);
PwmOut Servo_cmd(A0);

Serial PC(SERIAL_TX,SERIAL_RX);
Serial bt(D10 , D2);

DigitalOut Led1(A4);
DigitalOut Led2(A5);
Ticker timer1;
Ticker timer2;

/******************** Function ****************************/

void Hall_ITR_L();
void Hall_ITR_R();
void timer1_ITR();
void timer2_ITR();
void Initialize();
void PWM_setup(float Survo);
void bt_thread();

bool lightOn=0;


void timer1_ITR()
{

  for(int i=0;i<2;i++)
  {
  speed[i]= (float)counter[i] * 100.0f / 12.0f * 60.0f / 29.0f; 
  counter[i]=0;
    
    //count error
    if(input[i]==0) Output[i]=0;
        Error[i]=input[i]-speed[i];
        
        
        //****************  Ei ****************
        Ei[i]=Ei[i]+Error[i];
        if (Ei[i]>1000) Ei[i]=1000;
        else if (Ei[i]<-1000) Ei[i]=-1000;
        //****************  Ed = Error ****************
        if(speed[i]>0)
        {
        Output[i]=(Ei[i]*Ki[i]+Kp[i]*Error[i]) * factor ;
        }
        else
        {
        Output[i]=(Ei[i]*Ki[i]*Ki[i+2]+Kp[i]*Kp[i+2]*Error[i]) * factor ;
        }
       // if(reverse[i]==false) Output[i]*=-1;
        if(Error[i]<30)  Output[i]*=Gain[i];
        
        if (Output[i]>=Boundary_H) Output[i]=Boundary_H;        
        if (Output[i]<=Boundary_L) Output[i]=Boundary_L;
        
        Output[i]+=0.5;

    }
    
    Pwm_Left.write(Output[0]);
    TIM1->CCER |= 0x4;
    Pwm_Right.write(Output[1]);
    TIM1->CCER |= 0x40;
  //Servo_cmd.write(0.055);
  
//PC.printf("speed %lf Kp %lf Ki %lf input %lf output %lf \n",speed[1],Kp[1],Ki[1],input[1],Output[1]);

     
     
   
}
void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    
    if(PC.readable()) {
      read=PC.getc();
      if(read=='q') input[0]+=10;
      else if (read=='a') input[0]-=10;
      
      else if(read=='w') input[1]-=10;
      else if (read=='s')input[1]+=10;
      
      else if(read=='e') input[0]+=10;
      else if (read=='d') input[0]-=10;
      
      }

//PC.printf(" input %lf %lf \n",input[0],-input[1]);
}


void timer2_ITR()
{
        for(int i=0;i<2;i++)
  {
      speed2[i]= (float)counter2[i] * 60.0f / 12.0f / 29.0f; 
      counter2[i]=0;
   }
     // PC.printf("speed %lf %lf  \n",input[0],input[1]);
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
   // toggle_led_ticker.attach(&toggle_led, 0.1);
         

        // PC.attach(&callback);   
         PC.baud(115200);
         bt.baud(115200);
        Initialize();
      
}

void Initialize(){
    
    
    /***** HALL SENSOR *******/
    Hall_Left1.rise(&Hall_ITR_L);
    Hall_Left1.fall(&Hall_ITR_L);
    Hall_Left2.rise(&Hall_ITR_L);
    Hall_Left2.fall(&Hall_ITR_L);
    Hall_Right1.rise(&Hall_ITR_R);
    Hall_Right1.fall(&Hall_ITR_R);
    Hall_Right2.rise(&Hall_ITR_R);
    Hall_Right2.fall(&Hall_ITR_R);
    /******** PWM output*********/
    
    const short PWM_period=50;  //us
    
    Pwm_Left.period_us(PWM_period);
    Pwm_Left.write(0.5);
    TIM1->CCER |= 0x4;
    Pwm_Right.period_us(PWM_period);    
    Pwm_Right.write(0.5);
    TIM1->CCER |= 0x40;
    
    Servo_cmd.period_ms(20);
    Servo_cmd.write(dutyCycle);//degree=-40
    //servo_cmd.period_ms(20);
    //servo_cmd.write(servo_duty);
    /*********** Timer ************/
   
   
   input[0]=0;
   input[1]=0;
    
    wait_ms(1000);
    
    /*********** Timer ************/
    timer1.attach_us(&timer1_ITR,10000);
    timer2.attach(&timer2_ITR,1);
    
        bt.attach(&bt_thread,Serial::RxIrq);

 
}

void Hall_ITR_L(){
    //PC.printf("\nA");
    //Wheel[LEFT].ChangeState(Hall_Left1.read(),Hall_Left2.read());
    //PC.printf("%d %d",Hall_Left1.read(),Hall_Left2.read());
    
    Lstate[0]=Lstate[1];
    
    if(Hall_Left1.read())
    {
        if(Hall_Left2.read()) Lstate[1]=3;
        else Lstate[1]=4;
        }
     else
     {
         if(Hall_Left2.read()) Lstate[1]=2;
        else Lstate[1]=1;
         } 
       //if((Lstate[1]-Lstate[0])==0)  
     // PC.printf("stop \n");
      

      
       if((Lstate[1]-Lstate[0])==-1||(Lstate[1]-Lstate[0])==3)
      {
      //正轉    
       counter[0]--;
       counter2[0]--;
       reverse[0]=true; 
   //   PC.printf("clockwise \n");
      }
      else if ((Lstate[1]-Lstate[0])==1||(Lstate[1]-Lstate[0])==-3)
       {
        //逆轉   

     counter[0]++;
     counter2[0]++;    
      reverse[0]=false;      
   //    PC.printf("counterclockwise \n"); 
        }
    //PC.printf("B\n");
    
}
/****************************/
void Hall_ITR_R(){
   
   Rstate[0]=Rstate[1];
  
  if(Hall_Right1.read())
    {
        if(Hall_Right2.read()) Rstate[1]=3;
        else Rstate[1]=4;
        }
     else
     {
         if(Hall_Right2.read()) Rstate[1]=2;
        else Rstate[1]=1;
         }    
   // PC.printf("  %d %d\n",Hall_Right1.read(),Hall_Right2.read());
   if((Rstate[1]-Rstate[0])==1||(Rstate[1]-Lstate[0])==-3)
      {
      //正轉    
      counter[1]--;
      counter2[1]--;
      reverse[1]=false;   
     // PC.printf("positive\n");    
      }
      else if ((Rstate[1]-Rstate[0])==-1||(Rstate[1]-Rstate[0])==3)
       {
        //逆轉
        //PC.printf("negative\n");   
       counter[1]++;
       counter2[1]++;
       reverse[1]=true;   
        }
        
        
}

//bt

void bt_thread() {    

   
        
        
       
        // 254 127 data1_H data1_L data2_H data2_L data3_H data3_L 250 250
        while(bt.readable()){
             char getData=bt.getc();  
            //bt.putc(index+48);bt.putc(getData);//bt.putc('\n');
            //bt.putc(getData);
            //PC.printf("getdata %d   \n",bt.getc());
              //PC.printf(" getData %d\n",getData);
            
            if(getData==254&&btcount==0) 
            {
                btcount=1;
            } 
              if(getData==127&&btcount==1)
               {
                   btcount=2;
                  // PC.printf(" flag1 \n");
                }
              
              if(btcount==2)
              {
                 
                 temp_data[readcount]= getData;
                 PC.printf(" readcount %d Data %d\n",readcount,getData);
                 readcount++;
                 if(readcount>6)
                    {
                        btcmd[1] = (temp_data[2]<<8) | temp_data[1] ; 
                        input[0]= (btcmd[1]-1000);
                        //if(input[0]<0) input[0]=0;
                        btcmd[2] = (temp_data[4]<<8) | temp_data[3] ; 
                        input[1]=-(btcmd[2]-1000);
                        //if(input[1]>0) input[1]=0;
                        btcmd[3]=temp_data[5];
                        if(btcmd[3]==1)
                        Servo_cmd.write(0.06);
                        else
                        Servo_cmd.write(0.03);
                        readcount=0;
                        btcount=0;
                        
                        } 
                                     
                }
            
                

                
               // PC.printf("input %lf %lf  \n",input[0],input[1]);
                         
           
    } //bt.readable
}
