#include "Color.h"

Color::Color(I2C &i2c_handle,uint8_t cmd):i2c_handle_(i2c_handle)
{
    const char init[]={CTRL,RESET};//初期化のコマンド
    const char start[]={CTRL,cmd};//動作開始のコマンド
    i2c_handle_.write(ADDR,init,2);
    i2c_handle_.write(ADDR,start,2);
}
void Color::update(){
    static const char data_pos=READ;//レジスタの読み初めの場所
    i2c_handle_.write(ADDR,&data_pos,1);//読み込みの指定
    i2c_handle_.read(ADDR,data_,8);//データの受信
}
//16bitのデータを8bitの通信で受け取るから元のデータに戻す
uint16_t Color::r()const{return data_[0]<<8|data_[1];}
uint16_t Color::g()const{return data_[2]<<8|data_[3];}
uint16_t Color::b()const{return data_[4]<<8|data_[5];}
uint16_t Color::ir()const{return data_[6]<<8|data_[7];}