//S11059-02DTカラーセンサー用のライブラリ
#include "mbed.h"

#define ADDR (0x2A<<1)//センサーのアドレス
#define CTRL 0x00//コントロールレジスタ
#define READ 0x03//読み込む場所
#define RESET 0x89//ADCリセットとスリープ解除

class Color{
    private:
        I2C &i2c_handle_;//通信のハンドル
        char data_[8];//データを受信
    public:
        Color(I2C &i2c_handle,uint8_t cmd);//cmdは積分時間などの設定
        void update();//データの更新
        uint16_t r() const;//赤のパラメータ
        uint16_t g() const;//緑のパラメータ
        uint16_t b() const;//青のパラメータ
        uint16_t ir()const;//赤外線のパラメータ
};
/**使用例
#include "mbed.h"
#include "Color.h"

Serial pc(USBTX,USBRX);
I2C handle(PB_9,PB_8);

int main()
{
    Color color(handle,0x0B);
    while(1) {
        color.update();
        int R=color.r();
        int G=color.g();
        int B=color.b();
        int IR=color.ir();
        printf("R=%d G=%d B=%d IR=%d\r\n",R,G,B,IR);
        wait(1);
    }
}
*/