#ifndef LIBRARY_UW_H
#define LIBRARY_UW_H

#include "mbed.h"

//! 超音波センサ( Ultrasonic Distance Sensor (#28015))
/**
動作確認用プログラム
@code
#include "mbed.h"
#include "uw.h"

Uw uw1(PB_0);           //"DigitalInOut"のpinを宣言
DigitalOut led(LED1);   //デバック用ledを宣言

int main() {
    printf("start\n");
    while(1) {
        printf("%fcm\r\n",uw1.get_dist());
        led = !led;
        wait_ms(100);
    }
}
@endcode
*/

class Uw{
private:
    double dist;

protected:
    DigitalInOut uw_;
    Timer t;

public:
    /**コンストラクタの定義
     * メンバ変数の初期化を行う*/
    /**通常のpin定義のように使用するpinをプログラム内で実装する前に定義する
     * @param uw DigitalInOutを使用できるpinを定義する
     */
    Uw(PinName uw);
    /**get_dist関数の定義
     * 実際に超音波センサを用いて長さを測定する関数
     */
    /**@param rank 戻り値の単位を決定する
     * @remarks 1:[mm] 2:[m] その他･引数なし:[cm]
     * @return 測定した距離をrankに応じた単位で返す
     * @remarks 返却する値はdouble型
     */

    double get_dist(int rank = 0);
};


#endif