#include "uw.h"
#include "mbed.h"

Uw::Uw(PinName uw)   :   uw_(uw) {
    dist = 0;
}

double Uw::get_dist(int rank){
    double res;  
    
    uw_.output();
    uw_=0;
    wait_us(10);
    uw_=1;
    wait_us(5);
    uw_=0;
    
    uw_.input();    
    t.start();
    while(!uw_){
        t.reset();
        t.start();
        }
    do{
        res=t.read_us();        
    }while(uw_);
    t.reset();
    t.stop();
    
    
    dist=(res/2)/29.1;  //[cm]=[m/us]/[1/(us*100)]
    //  =       *343.6  //[cm]=[m/us]*[us*100]
    
    switch(rank){
        case 1:
        return dist*10;
        case 2:
        return dist*0.01;
        default:
        return dist;
    }
}
