#include "mbed.h"
#include "EC.h"

Serial pc(USBTX,USBRX);

int resolution = 1000; //エンコーダの分解能×逓倍

//ピン宣言
PwmOut motor_r_f(p21); //モータ正転
PwmOut motor_r_b(p22); //モータ逆転
PwmOut motor_l_f(p23); //モータ正転
PwmOut motor_l_b(p24); //モータ逆転


DigitalIn switch_max(p9); //直動機構の上限のリミットスイッチ
DigitalIn switch_min(p8); //直動機構の下限のリミットスイッチ
DigitalIn switch_x(p7); //X脚の接地を判定するスイッチ（今後実装予定）
DigitalIn switch_y(p5); //Y脚の接地を判定するスイッチ（今後実装予定）
DigitalIn switch_hand(p6); //ゲルゲ回収アームのスイッチ


//シリンダーの配列の番号
#define r_o_s 0     // right_outside_short
#define r_i_s 1     // right_inside_short
#define l_i_s 2
#define l_o_s 3
#define long_o 4    // long_outside
#define long_i 5    //long_inside
/*#define r_o_l 4
#define r_i_l 5
#define l_i_l 6
#define l_o_l 7*/

DigitalOut air[] = {     
    DigitalOut(p15),
    DigitalOut(p16),
    DigitalOut(p17),
    DigitalOut(p18),
    DigitalOut(p7),
    //DigitalOut(p20)
    DigitalOut(p5)
};



DigitalOut hand(p19); //ゲルゲ回収アームのハンド部開閉
DigitalOut gerege(p20); //ゲルゲ持ち上げ機構
Ec ec_l(p23,p24,NC,resolution,0.01); //エンコーダ右      外側前→正   外側の位置
Ec ec_r(p10,p12,NC,resolution,0.01); //エンコーダ左      外側前→正   外側の位置
//Ec ec_r(p7,p8,NC,resolution,0.01);//これはちぇびシェフのピン
//Ec ec_l(p6,p5,NC,resolution,0.01);
HCSR04 sensor(p30, p29);
KondoServo servo(p28,p27,1,115200); //旋回用のシリアルサーボ