/**
  ******************************************************************************
  * @file    signal_processing.c
  * @author  Brian Mazzeo
  * @date    2020
  * @brief   This file provides a set of code for signal processing in 487.
  *          Parts are taken from example code from STMIcroelectronics
  ******************************************************************************
  * @attention
  *          This code was specifically developed for BYU ECEn 487 course 
  *          Introduction to Digital Signal Processing.
  *
  *
  ******************************************************************************
  */ 

#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "arm_math.h"
#include "arm_const_structs.h"


/* ---------------------------------------------------------------------- 
** Defines for signal processing
** ------------------------------------------------------------------- */ 

#define AUDIO_BLOCK_SAMPLES             ((uint32_t)128)         // Number of samples (L and R) in audio block (each samples is 16 bits)
#define DFT_SIZE                        1024
#define DFT_CMPLX_DATA_SIZE             2048
#define FFT_TYPE                        arm_cfft_sR_f32_len1024

/* For Lab Exercise */
#define Lab_Execution_Type              0


/* Declare the array needed for the data */

uint32_t X_position_index;

/* FUNCTION DEFINITIONS BELOW */

/**
  * @brief  Initialize filter structures to be used in loops later
  * @retval None
  */
void initalize_signal_processing(void) {
    char buf[70];    

  switch (Lab_Execution_Type)
  {
  case 0: // Passthrough case
    break;
  
  case 1: // Direct computation of DFT
    break;
  
  case 2: // ARM version of DFT (FFT)
    break;
    
  case 3: // Two-channel spectrum analyzer - magnitude-squared version
    break;

  case 4: // Two-channel spectrum analyzer - dB version
    break;

  case 5: // Two-channel spectrum analyzer - dB Exponentially averaging version
    break;

  case 6: // Single-channel spectrum analyzer
    break;



  }
}

/**
  * @brief  Process audio channel signals
  * @param  L_channel_in: Pointer to Left channel data input (float32_t)
  * @param  R_channel_in: Pointer to Right channel data input (float32_t)
  * @param  L_channel_out: Pointer to Left channel data output (float32_t)
  * @param  R_channel_out: Pointer to Right channel data output (float32_t)
  * @param  Signal_Length: length of data to process
  * @retval None
  */
void process_audio_channel_signals(float32_t* L_channel_in, float32_t* R_channel_in, float32_t* L_channel_out, float32_t* R_channel_out, uint16_t Signal_Length)
{
    char buf[70];    
    BSP_LCD_SetFont(&Font8);
    BSP_LCD_SetTextColor(LCD_COLOR_CYAN);
    sprintf(buf, "Processing Signals" );
    BSP_LCD_DisplayStringAt(0, 125, (uint8_t *) buf, LEFT_MODE);
      
  switch(Lab_Execution_Type)
  {
  case 0: // Passthrough case
    arm_copy_f32(L_channel_in, L_channel_out, AUDIO_BLOCK_SAMPLES);
    arm_copy_f32(R_channel_in, R_channel_out, AUDIO_BLOCK_SAMPLES);
    break;
  
  case 1: // Direct computation of DFT
    break;
    
  case 2: // ARM version of DFT 
    break;
    
  case 3: // Two-channel spectrum analyzer - magnitude-squared version
    break;

  case 4: // Two-channel spectrum analyzer - dB version
    break;

  case 5: // Two-channel spectrum analyzer - dB Exponentially averaging version
    break;
    
  case 6: // Single-channel spectrogram
    break;

   
  }
    /* Change font back */  
    BSP_LCD_SetFont(&Font16);
}
