/**
  ******************************************************************************
  * @file    filter_coefficients.h
  * @author  Brian Mazzeo
  * @date    2020
  * @brief   This file provides a set of coefficients for DSP
  *          Parts are taken from example code from STMIcroelectronics
  ******************************************************************************
  * @attention
  *          This code was specifically developed for BYU ECEn 487 course 
  *          Introduction to Digital Signal Processing.
  *
  *
  ******************************************************************************
  */ 

#define NUM_TAPS                        890   
  
  /* ---------------------------------------------------------------------- 
** FIR Coefficients buffer generated using filterDesigner MATLAB function. 
** Fs = 16000
** Type = Bandpass at 1 kHz
** Design Method = equiripple
** Precision = Single-precision floating point
** ------------------------------------------------------------------- */ 

const float32_t Filter_coeffs[NUM_TAPS] = {
  -0.0001226540771,7.178472879e-05,6.184173253e-05,5.652113396e-05,5.249441165e-05,
  4.696934775e-05, 3.86458014e-05,2.684472202e-05,1.235085711e-05,-3.656656645e-06,
  -1.897664151e-05,-3.165631279e-05,-3.947582809e-05,-4.124792031e-05,-3.61845523e-05,
  -2.499801667e-05,-8.943332432e-06,9.396886526e-06,2.742723882e-05,4.197406815e-05,
  5.078753748e-05,5.190376396e-05,4.507824997e-05,3.071990795e-05,1.116666044e-05,
   -1.1129624e-05,-3.227870548e-05,-4.924209861e-05,-5.915368092e-05,-5.997941844e-05,
  -5.155095278e-05,-3.500421008e-05,-1.251889989e-05,1.241940754e-05,3.597744217e-05,
  5.427334327e-05, 6.45025284e-05,6.485514314e-05,5.530307681e-05,3.709313023e-05,
  1.313142729e-05, -1.3015886e-05,-3.712265971e-05,-5.556549877e-05,-6.533047417e-05,
  -6.509019295e-05,-5.481941844e-05,-3.638617636e-05,-1.263278591e-05,1.248503941e-05,
  3.519070742e-05,5.180476364e-05,6.014034443e-05,5.889592649e-05,4.888429612e-05,
  3.182289947e-05,1.084829364e-05,-1.06292382e-05,-2.906170994e-05,-4.189368701e-05,
  -4.729606371e-05,-4.509870996e-05,-3.617041148e-05,-2.275439147e-05,-7.376078884e-06,
  7.028426353e-06,1.824371429e-05,2.458147173e-05,2.576169391e-05, 2.23017305e-05,
  1.590635657e-05,8.453238479e-06, 2.12512964e-06,-1.656343102e-06,-2.000726226e-06,
  6.980739045e-07,5.367039648e-06,9.988577403e-06,1.260225508e-05, 1.12499938e-05,
  5.148846412e-06,-5.722018159e-06,-1.968171455e-05,-3.430873039e-05,-4.617224477e-05,
  -5.208898438e-05,-4.923491724e-05,-3.649069913e-05,-1.421774232e-05,1.491796684e-05,
  4.678799451e-05,7.576131611e-05,9.626714018e-05,0.0001031992215,9.356365626e-05,
  6.665196997e-05, 2.50898629e-05,-2.589770702e-05,-7.851831469e-05,-0.0001241559949,
  -0.0001541786623,-0.0001620521361,-0.0001440899214,-0.000100924517,-3.725395072e-05,
  3.810605995e-05,0.0001138795924,0.0001775129786,0.0002177670103,0.0002260741749,
  0.0001988188014,0.0001376811269,5.030281682e-05,-5.112997314e-05,-0.0001510301809,
  -0.0002333641751,-0.0002836686326,-0.0002920843835,-0.0002546804317,-0.0001750042866,
  -6.333021156e-05,6.409241178e-05,0.0001879253832,0.0002881641849,0.0003479142324,
  0.0003557082673,0.0003081560135,0.0002102741273,7.559673395e-05,-7.621022087e-05,
  -0.0002217346628,-0.0003379508271,-0.000405442639,-0.0004120858503,-0.0003547784581,
  -0.0002406881104,-8.592387894e-05,8.626351337e-05,0.0002495030349,0.0003779396066,
  0.0004508236016,0.0004554581537,0.0003898730502,0.0002628674847,9.328910528e-05,
  -9.324191342e-05,-0.0002678253222,-0.0004032893921,-0.0004780485469,-0.0004800411698,
  -0.0004082795058,-0.000273559679,-9.637011681e-05,9.584037616e-05,0.0002734452137,
  0.0004088439746,0.0004813160922,0.0004798145092,0.0004051521537,0.0002693668939,
  9.416198736e-05,-9.301523096e-05,-0.0002629837254,-0.0003898988944,-0.0004548834404,
  -0.0004493440501,-0.0003757325758,-0.0002473271161,-8.547100151e-05,8.364390669e-05,
  0.0002337178885,0.0003421768197,0.0003940742172,0.0003838550183,0.0003162827925,
  0.0002048519091, 6.95681083e-05,-6.701795792e-05,-0.0001833129063,-0.0002625972556,
  -0.0002951979404,-0.0002800586226,-0.000223996467,-0.0001403603819,-4.582374095e-05,
  4.247313336e-05,0.0001104648109,0.0001491806761,0.0001563815604,0.0001361135219,
   9.77027812e-05, 5.30326397e-05,1.410648656e-05,-1.002066256e-05,-1.489866645e-05,
  -1.945466011e-06,2.229299753e-05,4.741383236e-05,6.204376405e-05, 5.64136717e-05,
  2.536251486e-05,-3.016932533e-05,-0.0001022705037,-0.0001773568802,-0.0002382309176,
  -0.0002677857992,-0.0002524899028,-0.0001861133787,-7.176899089e-05,7.713999366e-05,
  0.0002385216503,0.0003844789171, 0.000486268953,0.0005193302059,0.0004686689936,
  0.0003324090212,0.0001238480763,-0.0001296174305,-0.0003896596027,-0.0006130152033,
  -0.0007583177066,-0.0007937494665,-0.0007031157729,-0.0004902316723,-0.0001796540018,
   0.000185565179,0.0005499963299,0.0008539834525, 0.001043595024, 0.001079773763,
  0.0009461040609,0.0006527720252,0.0002368152636,-0.0002425625717,-0.0007121732342,
  -0.001096252818,-0.001328499289,-0.001363614341,-0.001185564091,-0.0008118976839,
  -0.0002923281863,0.0002975625684,0.0008675617282, 0.001326521044, 0.001597195631,
   0.001629043953,  0.00140762399,0.0009580974584,0.0003428784839,-0.0003472095414,
  -0.001006269013,-0.001529925852,-0.001831822447,-0.001858117059,-0.001596813207,
  -0.001081023831,-0.0003847280459,0.0003877357813, 0.001117676264, 0.001690339181,
   0.002013346646, 0.002031588694, 0.001736821723, 0.001169646159,0.0004140580131,
  -0.000415301969,-0.001190644805,-0.001791183138,-0.002122089732,-0.002129861154,
  -0.001810961752,-0.001212899224,-0.0004269226338, 0.000425986771, 0.001214197953,
   0.001815978903, 0.002138791839,  0.00213369797, 0.001803093939, 0.001200010534,
  0.0004196301452,-0.0004161107936,-0.001177826547,-0.001749262097,-0.002045338042,
  -0.002025279915,-0.001698250649,-0.001121181878,-0.0003887457715,0.0003822936851,
   0.001072201878, 0.001577249146, 0.001825870597, 0.001789021073, 0.001483578701,
  0.0009679780924,0.0003314244677,-0.0003217677295,-0.0008895672509,-0.001288770232,
  -0.001467585796,-0.001412632992,-0.001149002812,-0.0007339895237,-0.0002454804489,
  0.0002324402158,0.0006243557436,0.0008758780896,0.0009617093601,0.0008878440131,
   0.000688035856,0.0004151701869,0.0001296492846,-0.000113141512,-0.0002735213493,
  -0.0003345988225,-0.0003041358141,-0.0002112253715,-9.82815036e-05,-1.032489308e-05,
  1.638532376e-05,-3.631333675e-05,-0.000163003715,-0.0003346393933,-0.0005039024982,
  -0.0006153268041,-0.0006180269993,-0.0004786847858,-0.0001917995978, 0.000214970918,
  0.0006821535062, 0.001126588788, 0.001455522608, 0.001584173995, 0.001453821082,
   0.001046691556,0.0003946469224,-0.0004207624297,-0.001277548261,-0.002031115349,
  -0.002538009547,-0.002681898419,  -0.0023970888,-0.001685281633,-0.0006218154449,
   0.000650430622, 0.001939551439,  0.00303316745, 0.003732935293, 0.003889354877,
   0.003431033809, 0.002382825129,0.0008690894465,-0.000899653649,-0.002655426506,
  -0.004113152623,-0.005016522016,-0.005182150751,-0.004534430802,-0.003124808427,
  -0.001131242723, 0.001163091627, 0.003409666708, 0.005247362889, 0.006360272411,
   0.006531239487, 0.005682230461, 0.003894192865, 0.001402206486,-0.001434573438,
  -0.004184418358,-0.006408720277,-0.007731804624,-0.007903833874,-0.006846284494,
  -0.004671963863,-0.001675212057, 0.001707295771, 0.004960114136, 0.007567660417,
   0.009095964022, 0.009264508262, 0.007996366359, 0.005437791348, 0.001943095354,
  -0.001974028535,-0.005716078915,-0.008693136275, -0.01041600015, -0.01057641208,
  -0.009101153351,-0.006170715205,-0.002198476577, 0.002227412304, 0.006431350484,
   0.009753778577,  0.01165496465,   0.0118026631,  0.01012946479, 0.006849961355,
   0.002434093039,-0.002460206626,-0.007085409947, -0.01071906649, -0.01277706958,
    -0.0129077239, -0.01105139498,-0.007455714513, -0.00264304853, 0.002665579086,
   0.007659008261,  0.01156049967,   0.0137491012,   0.0138587933,   0.0118395118,
    0.00796990376, 0.002819093876,-0.002837372478, -0.00813490618, -0.01225273591,
   -0.01454171818, -0.01462710463, -0.01246992499,-0.008376915008,-0.002956874669,
   0.002970349044, 0.008498573676,  0.01277460624,  0.01513064094,  0.01518908795,
    0.01292326953, 0.008664226159, 0.003052147338,-0.003060404677,-0.008738774806,
   -0.01310996711, -0.01549763605, -0.01552732382, -0.01318548061,-0.008822916076,
  -0.003101953771,  0.00310473307, 0.008848027326,  0.01324836724,  0.01563125663,
    0.01563125663,  0.01324836724, 0.008848027326,  0.00310473307,-0.003101953771,
  -0.008822916076, -0.01318548061, -0.01552732382, -0.01549763605, -0.01310996711,
  -0.008738774806,-0.003060404677, 0.003052147338, 0.008664226159,  0.01292326953,
    0.01518908795,  0.01513064094,  0.01277460624, 0.008498573676, 0.002970349044,
  -0.002956874669,-0.008376915008, -0.01246992499, -0.01462710463, -0.01454171818,
   -0.01225273591, -0.00813490618,-0.002837372478, 0.002819093876,  0.00796990376,
     0.0118395118,   0.0138587933,   0.0137491012,  0.01156049967, 0.007659008261,
   0.002665579086, -0.00264304853,-0.007455714513, -0.01105139498,  -0.0129077239,
   -0.01277706958, -0.01071906649,-0.007085409947,-0.002460206626, 0.002434093039,
   0.006849961355,  0.01012946479,   0.0118026631,  0.01165496465, 0.009753778577,
   0.006431350484, 0.002227412304,-0.002198476577,-0.006170715205,-0.009101153351,
   -0.01057641208, -0.01041600015,-0.008693136275,-0.005716078915,-0.001974028535,
   0.001943095354, 0.005437791348, 0.007996366359, 0.009264508262, 0.009095964022,
   0.007567660417, 0.004960114136, 0.001707295771,-0.001675212057,-0.004671963863,
  -0.006846284494,-0.007903833874,-0.007731804624,-0.006408720277,-0.004184418358,
  -0.001434573438, 0.001402206486, 0.003894192865, 0.005682230461, 0.006531239487,
   0.006360272411, 0.005247362889, 0.003409666708, 0.001163091627,-0.001131242723,
  -0.003124808427,-0.004534430802,-0.005182150751,-0.005016522016,-0.004113152623,
  -0.002655426506,-0.000899653649,0.0008690894465, 0.002382825129, 0.003431033809,
   0.003889354877, 0.003732935293,  0.00303316745, 0.001939551439, 0.000650430622,
  -0.0006218154449,-0.001685281633,  -0.0023970888,-0.002681898419,-0.002538009547,
  -0.002031115349,-0.001277548261,-0.0004207624297,0.0003946469224, 0.001046691556,
   0.001453821082, 0.001584173995, 0.001455522608, 0.001126588788,0.0006821535062,
   0.000214970918,-0.0001917995978,-0.0004786847858,-0.0006180269993,-0.0006153268041,
  -0.0005039024982,-0.0003346393933,-0.000163003715,-3.631333675e-05,1.638532376e-05,
  -1.032489308e-05,-9.82815036e-05,-0.0002112253715,-0.0003041358141,-0.0003345988225,
  -0.0002735213493,-0.000113141512,0.0001296492846,0.0004151701869, 0.000688035856,
  0.0008878440131,0.0009617093601,0.0008758780896,0.0006243557436,0.0002324402158,
  -0.0002454804489,-0.0007339895237,-0.001149002812,-0.001412632992,-0.001467585796,
  -0.001288770232,-0.0008895672509,-0.0003217677295,0.0003314244677,0.0009679780924,
   0.001483578701, 0.001789021073, 0.001825870597, 0.001577249146, 0.001072201878,
  0.0003822936851,-0.0003887457715,-0.001121181878,-0.001698250649,-0.002025279915,
  -0.002045338042,-0.001749262097,-0.001177826547,-0.0004161107936,0.0004196301452,
   0.001200010534, 0.001803093939,  0.00213369797, 0.002138791839, 0.001815978903,
   0.001214197953, 0.000425986771,-0.0004269226338,-0.001212899224,-0.001810961752,
  -0.002129861154,-0.002122089732,-0.001791183138,-0.001190644805,-0.000415301969,
  0.0004140580131, 0.001169646159, 0.001736821723, 0.002031588694, 0.002013346646,
   0.001690339181, 0.001117676264,0.0003877357813,-0.0003847280459,-0.001081023831,
  -0.001596813207,-0.001858117059,-0.001831822447,-0.001529925852,-0.001006269013,
  -0.0003472095414,0.0003428784839,0.0009580974584,  0.00140762399, 0.001629043953,
   0.001597195631, 0.001326521044,0.0008675617282,0.0002975625684,-0.0002923281863,
  -0.0008118976839,-0.001185564091,-0.001363614341,-0.001328499289,-0.001096252818,
  -0.0007121732342,-0.0002425625717,0.0002368152636,0.0006527720252,0.0009461040609,
   0.001079773763, 0.001043595024,0.0008539834525,0.0005499963299, 0.000185565179,
  -0.0001796540018,-0.0004902316723,-0.0007031157729,-0.0007937494665,-0.0007583177066,
  -0.0006130152033,-0.0003896596027,-0.0001296174305,0.0001238480763,0.0003324090212,
  0.0004686689936,0.0005193302059, 0.000486268953,0.0003844789171,0.0002385216503,
  7.713999366e-05,-7.176899089e-05,-0.0001861133787,-0.0002524899028,-0.0002677857992,
  -0.0002382309176,-0.0001773568802,-0.0001022705037,-3.016932533e-05,2.536251486e-05,
   5.64136717e-05,6.204376405e-05,4.741383236e-05,2.229299753e-05,-1.945466011e-06,
  -1.489866645e-05,-1.002066256e-05,1.410648656e-05, 5.30326397e-05, 9.77027812e-05,
  0.0001361135219,0.0001563815604,0.0001491806761,0.0001104648109,4.247313336e-05,
  -4.582374095e-05,-0.0001403603819,-0.000223996467,-0.0002800586226,-0.0002951979404,
  -0.0002625972556,-0.0001833129063,-6.701795792e-05, 6.95681083e-05,0.0002048519091,
  0.0003162827925,0.0003838550183,0.0003940742172,0.0003421768197,0.0002337178885,
  8.364390669e-05,-8.547100151e-05,-0.0002473271161,-0.0003757325758,-0.0004493440501,
  -0.0004548834404,-0.0003898988944,-0.0002629837254,-9.301523096e-05,9.416198736e-05,
  0.0002693668939,0.0004051521537,0.0004798145092,0.0004813160922,0.0004088439746,
  0.0002734452137,9.584037616e-05,-9.637011681e-05,-0.000273559679,-0.0004082795058,
  -0.0004800411698,-0.0004780485469,-0.0004032893921,-0.0002678253222,-9.324191342e-05,
  9.328910528e-05,0.0002628674847,0.0003898730502,0.0004554581537,0.0004508236016,
  0.0003779396066,0.0002495030349,8.626351337e-05,-8.592387894e-05,-0.0002406881104,
  -0.0003547784581,-0.0004120858503,-0.000405442639,-0.0003379508271,-0.0002217346628,
  -7.621022087e-05,7.559673395e-05,0.0002102741273,0.0003081560135,0.0003557082673,
  0.0003479142324,0.0002881641849,0.0001879253832,6.409241178e-05,-6.333021156e-05,
  -0.0001750042866,-0.0002546804317,-0.0002920843835,-0.0002836686326,-0.0002333641751,
  -0.0001510301809,-5.112997314e-05,5.030281682e-05,0.0001376811269,0.0001988188014,
  0.0002260741749,0.0002177670103,0.0001775129786,0.0001138795924,3.810605995e-05,
  -3.725395072e-05,-0.000100924517,-0.0001440899214,-0.0001620521361,-0.0001541786623,
  -0.0001241559949,-7.851831469e-05,-2.589770702e-05, 2.50898629e-05,6.665196997e-05,
  9.356365626e-05,0.0001031992215,9.626714018e-05,7.576131611e-05,4.678799451e-05,
  1.491796684e-05,-1.421774232e-05,-3.649069913e-05,-4.923491724e-05,-5.208898438e-05,
  -4.617224477e-05,-3.430873039e-05,-1.968171455e-05,-5.722018159e-06,5.148846412e-06,
   1.12499938e-05,1.260225508e-05,9.988577403e-06,5.367039648e-06,6.980739045e-07,
  -2.000726226e-06,-1.656343102e-06, 2.12512964e-06,8.453238479e-06,1.590635657e-05,
   2.23017305e-05,2.576169391e-05,2.458147173e-05,1.824371429e-05,7.028426353e-06,
  -7.376078884e-06,-2.275439147e-05,-3.617041148e-05,-4.509870996e-05,-4.729606371e-05,
  -4.189368701e-05,-2.906170994e-05,-1.06292382e-05,1.084829364e-05,3.182289947e-05,
  4.888429612e-05,5.889592649e-05,6.014034443e-05,5.180476364e-05,3.519070742e-05,
  1.248503941e-05,-1.263278591e-05,-3.638617636e-05,-5.481941844e-05,-6.509019295e-05,
  -6.533047417e-05,-5.556549877e-05,-3.712265971e-05, -1.3015886e-05,1.313142729e-05,
  3.709313023e-05,5.530307681e-05,6.485514314e-05, 6.45025284e-05,5.427334327e-05,
  3.597744217e-05,1.241940754e-05,-1.251889989e-05,-3.500421008e-05,-5.155095278e-05,
  -5.997941844e-05,-5.915368092e-05,-4.924209861e-05,-3.227870548e-05, -1.1129624e-05,
  1.116666044e-05,3.071990795e-05,4.507824997e-05,5.190376396e-05,5.078753748e-05,
  4.197406815e-05,2.742723882e-05,9.396886526e-06,-8.943332432e-06,-2.499801667e-05,
  -3.61845523e-05,-4.124792031e-05,-3.947582809e-05,-3.165631279e-05,-1.897664151e-05,
  -3.656656645e-06,1.235085711e-05,2.684472202e-05, 3.86458014e-05,4.696934775e-05,
  5.249441165e-05,5.652113396e-05,6.184173253e-05,7.178472879e-05,-0.0001226540771
};
